package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.type1.label._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CLabel;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Type1Label} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Type1Label createType1Label(int fooXyzzy, int barBaz) {
 *         return new Type1LabelBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Type1Label, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Type1Label
 *
 */
@Generated("mdsal-binding-generator")
public class Type1LabelBuilder {

    private Uint32 _type1Label;


    Map<Class<? extends Augmentation<Type1Label>>, Augmentation<Type1Label>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public Type1LabelBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Type1Label}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Type1Label from which the builder should be initialized
     */
    public Type1LabelBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Type1Label arg) {
        this._type1Label = arg.getType1Label();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CLabel}.
     *
     * @param arg CLabel from which the builder should be initialized
     */
    public Type1LabelBuilder(CLabel arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Type1Label}.
     *
     * @param base Type1Label from which the builder should be initialized
     */
    public Type1LabelBuilder(Type1Label base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._type1Label = base.getType1Label();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link CLabel}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Type1Label}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CLabel castArg) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Type1Label castArg) {
            this._type1Label = castArg.getType1Label();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[CLabel, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Type1Label]");
    }

    private static final class LazyEmpty {
        static final @NonNull Type1Label INSTANCE = new Type1LabelBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Type1Label.
     *
     * @return An empty {@link Type1Label}
     */
    public static @NonNull Type1Label empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Type1Label#getType1Label()}.
     *
     * @return current value
     */
    public Uint32 getType1Label() {
        return _type1Label;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Type1Label>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Type1Label#getType1Label()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Type1LabelBuilder setType1Label(final Uint32 value) {
        this._type1Label = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Type1LabelBuilder addAugmentation(Augmentation<Type1Label> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Type1LabelBuilder removeAugmentation(Class<? extends Augmentation<Type1Label>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Type1Label} instance.
     *
     * @return A new {@link Type1Label} instance.
     */
    public @NonNull Type1Label build() {
        return new Type1LabelImpl(this);
    }

    private static final class Type1LabelImpl
        extends AbstractAugmentable<Type1Label>
        implements Type1Label {
    
        private final Uint32 _type1Label;
    
        Type1LabelImpl(Type1LabelBuilder base) {
            super(base.augmentation);
            this._type1Label = base.getType1Label();
        }
    
        @Override
        public Uint32 getType1Label() {
            return _type1Label;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Type1Label.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Type1Label.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Type1Label.bindingToString(this);
        }
    }
}
