package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CLabel;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link WavebandSwitchingLabel} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     WavebandSwitchingLabel createWavebandSwitchingLabel(int fooXyzzy, int barBaz) {
 *         return new WavebandSwitchingLabelBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of WavebandSwitchingLabel, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see WavebandSwitchingLabel
 *
 */
@Generated("mdsal-binding-generator")
public class WavebandSwitchingLabelBuilder {

    private Uint32 _endLabel;
    private Uint32 _startLabel;
    private Uint32 _wavebandId;


    Map<Class<? extends Augmentation<WavebandSwitchingLabel>>, Augmentation<WavebandSwitchingLabel>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public WavebandSwitchingLabelBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel from which the builder should be initialized
     */
    public WavebandSwitchingLabelBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel arg) {
        this._endLabel = arg.getEndLabel();
        this._startLabel = arg.getStartLabel();
        this._wavebandId = arg.getWavebandId();
    }
    
    /**
     * Construct a new builder initialized from specified {@link CLabel}.
     *
     * @param arg CLabel from which the builder should be initialized
     */
    public WavebandSwitchingLabelBuilder(CLabel arg) {
    }
    

    /**
     * Construct a builder initialized with state from specified {@link WavebandSwitchingLabel}.
     *
     * @param base WavebandSwitchingLabel from which the builder should be initialized
     */
    public WavebandSwitchingLabelBuilder(WavebandSwitchingLabel base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._endLabel = base.getEndLabel();
        this._startLabel = base.getStartLabel();
        this._wavebandId = base.getWavebandId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel}</li>
     *   <li>{@link CLabel}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel castArg) {
            this._endLabel = castArg.getEndLabel();
            this._startLabel = castArg.getStartLabel();
            this._wavebandId = castArg.getWavebandId();
            isValidArg = true;
        }
        if (arg instanceof CLabel castArg) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel, CLabel]");
    }

    private static final class LazyEmpty {
        static final @NonNull WavebandSwitchingLabel INSTANCE = new WavebandSwitchingLabelBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of WavebandSwitchingLabel.
     *
     * @return An empty {@link WavebandSwitchingLabel}
     */
    public static @NonNull WavebandSwitchingLabel empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link WavebandSwitchingLabel#getEndLabel()}.
     *
     * @return current value
     */
    public Uint32 getEndLabel() {
        return _endLabel;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link WavebandSwitchingLabel#getStartLabel()}.
     *
     * @return current value
     */
    public Uint32 getStartLabel() {
        return _startLabel;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link WavebandSwitchingLabel#getWavebandId()}.
     *
     * @return current value
     */
    public Uint32 getWavebandId() {
        return _wavebandId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<WavebandSwitchingLabel>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link WavebandSwitchingLabel#getEndLabel()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public WavebandSwitchingLabelBuilder setEndLabel(final Uint32 value) {
        this._endLabel = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link WavebandSwitchingLabel#getStartLabel()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public WavebandSwitchingLabelBuilder setStartLabel(final Uint32 value) {
        this._startLabel = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link WavebandSwitchingLabel#getWavebandId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public WavebandSwitchingLabelBuilder setWavebandId(final Uint32 value) {
        this._wavebandId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public WavebandSwitchingLabelBuilder addAugmentation(Augmentation<WavebandSwitchingLabel> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public WavebandSwitchingLabelBuilder removeAugmentation(Class<? extends Augmentation<WavebandSwitchingLabel>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link WavebandSwitchingLabel} instance.
     *
     * @return A new {@link WavebandSwitchingLabel} instance.
     */
    public @NonNull WavebandSwitchingLabel build() {
        return new WavebandSwitchingLabelImpl(this);
    }

    private static final class WavebandSwitchingLabelImpl
        extends AbstractAugmentable<WavebandSwitchingLabel>
        implements WavebandSwitchingLabel {
    
        private final Uint32 _endLabel;
        private final Uint32 _startLabel;
        private final Uint32 _wavebandId;
    
        WavebandSwitchingLabelImpl(WavebandSwitchingLabelBuilder base) {
            super(base.augmentation);
            this._endLabel = base.getEndLabel();
            this._startLabel = base.getStartLabel();
            this._wavebandId = base.getWavebandId();
        }
    
        @Override
        public Uint32 getEndLabel() {
            return _endLabel;
        }
        
        @Override
        public Uint32 getStartLabel() {
            return _startLabel;
        }
        
        @Override
        public Uint32 getWavebandId() {
            return _wavebandId;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = WavebandSwitchingLabel.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return WavebandSwitchingLabel.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return WavebandSwitchingLabel.bindingToString(this);
        }
    }
}
