package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.lsp.required.attributes.object;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.lsp.attributes.object.LspAttributesObject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link LspRequiredAttributesObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     LspRequiredAttributesObject createLspRequiredAttributesObject(int fooXyzzy, int barBaz) {
 *         return new LspRequiredAttributesObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of LspRequiredAttributesObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see LspRequiredAttributesObject
 *
 */
@Generated("mdsal-binding-generator")
public class LspRequiredAttributesObjectBuilder {

    private LspAttributesObject _lspAttributesObject;


    Map<Class<? extends Augmentation<LspRequiredAttributesObject>>, Augmentation<LspRequiredAttributesObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public LspRequiredAttributesObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public LspRequiredAttributesObjectBuilder(RsvpTeObject arg) {
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspAttributesObject}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspAttributesObject from which the builder should be initialized
     */
    public LspRequiredAttributesObjectBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspAttributesObject arg) {
        this._lspAttributesObject = arg.getLspAttributesObject();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link LspRequiredAttributesObject}.
     *
     * @param base LspRequiredAttributesObject from which the builder should be initialized
     */
    public LspRequiredAttributesObjectBuilder(LspRequiredAttributesObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._lspAttributesObject = base.getLspAttributesObject();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link RsvpTeObject}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspAttributesObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspAttributesObject castArg) {
            this._lspAttributesObject = castArg.getLspAttributesObject();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[RsvpTeObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspAttributesObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull LspRequiredAttributesObject INSTANCE = new LspRequiredAttributesObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of LspRequiredAttributesObject.
     *
     * @return An empty {@link LspRequiredAttributesObject}
     */
    public static @NonNull LspRequiredAttributesObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link LspRequiredAttributesObject#getLspAttributesObject()}.
     *
     * @return current value
     */
    public LspAttributesObject getLspAttributesObject() {
        return _lspAttributesObject;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<LspRequiredAttributesObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link LspRequiredAttributesObject#getLspAttributesObject()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public LspRequiredAttributesObjectBuilder setLspAttributesObject(final LspAttributesObject value) {
        this._lspAttributesObject = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public LspRequiredAttributesObjectBuilder addAugmentation(Augmentation<LspRequiredAttributesObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public LspRequiredAttributesObjectBuilder removeAugmentation(Class<? extends Augmentation<LspRequiredAttributesObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link LspRequiredAttributesObject} instance.
     *
     * @return A new {@link LspRequiredAttributesObject} instance.
     */
    public @NonNull LspRequiredAttributesObject build() {
        return new LspRequiredAttributesObjectImpl(this);
    }

    private static final class LspRequiredAttributesObjectImpl
        extends AbstractAugmentable<LspRequiredAttributesObject>
        implements LspRequiredAttributesObject {
    
        private final LspAttributesObject _lspAttributesObject;
    
        LspRequiredAttributesObjectImpl(LspRequiredAttributesObjectBuilder base) {
            super(base.augmentation);
            this._lspAttributesObject = base.getLspAttributesObject();
        }
    
        @Override
        public LspAttributesObject getLspAttributesObject() {
            return _lspAttributesObject;
        }
    
        @Override
        public LspAttributesObject nonnullLspAttributesObject() {
            return Objects.requireNonNullElse(getLspAttributesObject(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.lsp.attributes.object.LspAttributesObjectBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = LspRequiredAttributesObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return LspRequiredAttributesObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return LspRequiredAttributesObject.bindingToString(this);
        }
    }
}
