package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LinkFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspFlag;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>rsvp</b>
 * <pre>
 * container protection-subobject {
 *   leaf secondary {
 *     type boolean;
 *     default false;
 *   }
 *   leaf protecting {
 *     type boolean;
 *     default false;
 *   }
 *   leaf notification {
 *     type boolean;
 *     default false;
 *   }
 *   leaf operational {
 *     type boolean;
 *     default false;
 *   }
 *   leaf lsp-flag {
 *     type lsp-flag;
 *   }
 *   leaf link-flags {
 *     type link-flags;
 *   }
 *   leaf in-place {
 *     type boolean;
 *     default false;
 *   }
 *   leaf required {
 *     type boolean;
 *     default false;
 *   }
 *   leaf seg-flag {
 *     type lsp-flag;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ProtectionSubobjectBuilder}.
 * @see ProtectionSubobjectBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ProtectionSubobject
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ProtectionSubobject>,
    Augmentable<ProtectionSubobject>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("protection-subobject");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.ProtectionSubobject> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.ProtectionSubobject.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.@NonNull ProtectionSubobject obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getInPlace());
        result = prime * result + Objects.hashCode(obj.getLinkFlags());
        result = prime * result + Objects.hashCode(obj.getLspFlag());
        result = prime * result + Objects.hashCode(obj.getNotification());
        result = prime * result + Objects.hashCode(obj.getOperational());
        result = prime * result + Objects.hashCode(obj.getProtecting());
        result = prime * result + Objects.hashCode(obj.getRequired());
        result = prime * result + Objects.hashCode(obj.getSecondary());
        result = prime * result + Objects.hashCode(obj.getSegFlag());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.@NonNull ProtectionSubobject thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.ProtectionSubobject.class, obj);
        return other != null
            && Objects.equals(thisObj.getInPlace(), other.getInPlace())
            && Objects.equals(thisObj.getNotification(), other.getNotification())
            && Objects.equals(thisObj.getOperational(), other.getOperational())
            && Objects.equals(thisObj.getProtecting(), other.getProtecting())
            && Objects.equals(thisObj.getRequired(), other.getRequired())
            && Objects.equals(thisObj.getSecondary(), other.getSecondary())
            && Objects.equals(thisObj.getLinkFlags(), other.getLinkFlags())
            && Objects.equals(thisObj.getLspFlag(), other.getLspFlag())
            && Objects.equals(thisObj.getSegFlag(), other.getSegFlag())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.@NonNull ProtectionSubobject obj) {
        final var helper = MoreObjects.toStringHelper("ProtectionSubobject");
        CodeHelpers.appendValue(helper, "inPlace", obj.getInPlace());
        CodeHelpers.appendValue(helper, "linkFlags", obj.getLinkFlags());
        CodeHelpers.appendValue(helper, "lspFlag", obj.getLspFlag());
        CodeHelpers.appendValue(helper, "notification", obj.getNotification());
        CodeHelpers.appendValue(helper, "operational", obj.getOperational());
        CodeHelpers.appendValue(helper, "protecting", obj.getProtecting());
        CodeHelpers.appendValue(helper, "required", obj.getRequired());
        CodeHelpers.appendValue(helper, "secondary", obj.getSecondary());
        CodeHelpers.appendValue(helper, "segFlag", obj.getSegFlag());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return secondary, or {@code null} if it is not present.
     *
     * @return {@code Boolean} secondary, or {@code null} if it is not present.
     *
     */
    Boolean getSecondary();
    
    /**
     * Return secondary, guaranteed to be non-null.
     *
     * @return {@code Boolean} secondary, guaranteed to be non-null.
     * @throws NoSuchElementException if secondary is not present
     *
     */
    default @NonNull Boolean requireSecondary() {
        return CodeHelpers.require(getSecondary(), "secondary");
    }
    
    /**
     * Return protecting, or {@code null} if it is not present.
     *
     * @return {@code Boolean} protecting, or {@code null} if it is not present.
     *
     */
    Boolean getProtecting();
    
    /**
     * Return protecting, guaranteed to be non-null.
     *
     * @return {@code Boolean} protecting, guaranteed to be non-null.
     * @throws NoSuchElementException if protecting is not present
     *
     */
    default @NonNull Boolean requireProtecting() {
        return CodeHelpers.require(getProtecting(), "protecting");
    }
    
    /**
     * Return notification, or {@code null} if it is not present.
     *
     * @return {@code Boolean} notification, or {@code null} if it is not present.
     *
     */
    Boolean getNotification();
    
    /**
     * Return notification, guaranteed to be non-null.
     *
     * @return {@code Boolean} notification, guaranteed to be non-null.
     * @throws NoSuchElementException if notification is not present
     *
     */
    default @NonNull Boolean requireNotification() {
        return CodeHelpers.require(getNotification(), "notification");
    }
    
    /**
     * Return operational, or {@code null} if it is not present.
     *
     * @return {@code Boolean} operational, or {@code null} if it is not present.
     *
     */
    Boolean getOperational();
    
    /**
     * Return operational, guaranteed to be non-null.
     *
     * @return {@code Boolean} operational, guaranteed to be non-null.
     * @throws NoSuchElementException if operational is not present
     *
     */
    default @NonNull Boolean requireOperational() {
        return CodeHelpers.require(getOperational(), "operational");
    }
    
    /**
     * Return lspFlag, or {@code null} if it is not present.
     *
     * @return {@code LspFlag} lspFlag, or {@code null} if it is not present.
     *
     */
    LspFlag getLspFlag();
    
    /**
     * Return lspFlag, guaranteed to be non-null.
     *
     * @return {@code LspFlag} lspFlag, guaranteed to be non-null.
     * @throws NoSuchElementException if lspFlag is not present
     *
     */
    default @NonNull LspFlag requireLspFlag() {
        return CodeHelpers.require(getLspFlag(), "lspflag");
    }
    
    /**
     * Return linkFlags, or {@code null} if it is not present.
     *
     * @return {@code LinkFlags} linkFlags, or {@code null} if it is not present.
     *
     */
    LinkFlags getLinkFlags();
    
    /**
     * Return linkFlags, guaranteed to be non-null.
     *
     * @return {@code LinkFlags} linkFlags, guaranteed to be non-null.
     * @throws NoSuchElementException if linkFlags is not present
     *
     */
    default @NonNull LinkFlags requireLinkFlags() {
        return CodeHelpers.require(getLinkFlags(), "linkflags");
    }
    
    /**
     * Return inPlace, or {@code null} if it is not present.
     *
     * @return {@code Boolean} inPlace, or {@code null} if it is not present.
     *
     */
    Boolean getInPlace();
    
    /**
     * Return inPlace, guaranteed to be non-null.
     *
     * @return {@code Boolean} inPlace, guaranteed to be non-null.
     * @throws NoSuchElementException if inPlace is not present
     *
     */
    default @NonNull Boolean requireInPlace() {
        return CodeHelpers.require(getInPlace(), "inplace");
    }
    
    /**
     * Return required, or {@code null} if it is not present.
     *
     * @return {@code Boolean} required, or {@code null} if it is not present.
     *
     */
    Boolean getRequired();
    
    /**
     * Return required, guaranteed to be non-null.
     *
     * @return {@code Boolean} required, guaranteed to be non-null.
     * @throws NoSuchElementException if required is not present
     *
     */
    default @NonNull Boolean requireRequired() {
        return CodeHelpers.require(getRequired(), "d");
    }
    
    /**
     * Return segFlag, or {@code null} if it is not present.
     *
     * @return {@code LspFlag} segFlag, or {@code null} if it is not present.
     *
     */
    LspFlag getSegFlag();
    
    /**
     * Return segFlag, guaranteed to be non-null.
     *
     * @return {@code LspFlag} segFlag, guaranteed to be non-null.
     * @throws NoSuchElementException if segFlag is not present
     *
     */
    default @NonNull LspFlag requireSegFlag() {
        return CodeHelpers.require(getSegFlag(), "segflag");
    }

}

