package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.secondary.explicit.route.subobjects.subobject.type.basic.protection._case;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.ProtectionSubobject;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BasicProtection} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BasicProtection createBasicProtection(int fooXyzzy, int barBaz) {
 *         return new BasicProtectionBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BasicProtection, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BasicProtection
 *
 */
@Generated("mdsal-binding-generator")
public class BasicProtectionBuilder {

    private ProtectionSubobject _protectionSubobject;


    Map<Class<? extends Augmentation<BasicProtection>>, Augmentation<BasicProtection>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public BasicProtectionBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ProtectionSubobject}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ProtectionSubobject from which the builder should be initialized
     */
    public BasicProtectionBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ProtectionSubobject arg) {
        this._protectionSubobject = arg.getProtectionSubobject();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link BasicProtection}.
     *
     * @param base BasicProtection from which the builder should be initialized
     */
    public BasicProtectionBuilder(BasicProtection base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._protectionSubobject = base.getProtectionSubobject();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ProtectionSubobject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ProtectionSubobject castArg) {
            this._protectionSubobject = castArg.getProtectionSubobject();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ProtectionSubobject]");
    }

    private static final class LazyEmpty {
        static final @NonNull BasicProtection INSTANCE = new BasicProtectionBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of BasicProtection.
     *
     * @return An empty {@link BasicProtection}
     */
    public static @NonNull BasicProtection empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link BasicProtection#getProtectionSubobject()}.
     *
     * @return current value
     */
    public ProtectionSubobject getProtectionSubobject() {
        return _protectionSubobject;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BasicProtection>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link BasicProtection#getProtectionSubobject()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicProtectionBuilder setProtectionSubobject(final ProtectionSubobject value) {
        this._protectionSubobject = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BasicProtectionBuilder addAugmentation(Augmentation<BasicProtection> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BasicProtectionBuilder removeAugmentation(Class<? extends Augmentation<BasicProtection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link BasicProtection} instance.
     *
     * @return A new {@link BasicProtection} instance.
     */
    public @NonNull BasicProtection build() {
        return new BasicProtectionImpl(this);
    }

    private static final class BasicProtectionImpl
        extends AbstractAugmentable<BasicProtection>
        implements BasicProtection {
    
        private final ProtectionSubobject _protectionSubobject;
    
        BasicProtectionImpl(BasicProtectionBuilder base) {
            super(base.augmentation);
            this._protectionSubobject = base.getProtectionSubobject();
        }
    
        @Override
        public ProtectionSubobject getProtectionSubobject() {
            return _protectionSubobject;
        }
    
        @Override
        public ProtectionSubobject nonnullProtectionSubobject() {
            return Objects.requireNonNullElse(getProtectionSubobject(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.ProtectionSubobjectBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = BasicProtection.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return BasicProtection.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return BasicProtection.bindingToString(this);
        }
    }
}
