package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.session.attribute.object.session.attribute.object.basic.session.attribute.object._case;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link BasicSessionAttributeObject} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BasicSessionAttributeObject createBasicSessionAttributeObject(int fooXyzzy, int barBaz) {
 *         return new BasicSessionAttributeObjectBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BasicSessionAttributeObject, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BasicSessionAttributeObject
 *
 */
@Generated("mdsal-binding-generator")
public class BasicSessionAttributeObjectBuilder {

    private AttributeFilter _excludeAny;
    private Uint8 _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _seStyleDesired;
    private String _sessionName;
    private Uint8 _setupPriority;


    Map<Class<? extends Augmentation<BasicSessionAttributeObject>>, Augmentation<BasicSessionAttributeObject>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public BasicSessionAttributeObjectBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link RsvpTeObject}.
     *
     * @param arg RsvpTeObject from which the builder should be initialized
     */
    public BasicSessionAttributeObjectBuilder(RsvpTeObject arg) {
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link TunnelAttributes}.
     *
     * @param arg TunnelAttributes from which the builder should be initialized
     */
    public BasicSessionAttributeObjectBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link Priority}.
     *
     * @param arg Priority from which the builder should be initialized
     */
    public BasicSessionAttributeObjectBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    
    /**
     * Construct a new builder initialized from specified {@link AttributeFilters}.
     *
     * @param arg AttributeFilters from which the builder should be initialized
     */
    public BasicSessionAttributeObjectBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link BasicSessionAttributeObject}.
     *
     * @param base BasicSessionAttributeObject from which the builder should be initialized
     */
    public BasicSessionAttributeObjectBuilder(BasicSessionAttributeObject base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._labelRecordingDesired = base.getLabelRecordingDesired();
        this._localProtectionDesired = base.getLocalProtectionDesired();
        this._seStyleDesired = base.getSeStyleDesired();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link Priority}</li>
     *   <li>{@link AttributeFilters}</li>
     *   <li>{@link RsvpTeObject}</li>
     *   <li>{@link TunnelAttributes}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Priority castArg) {
            this._holdPriority = castArg.getHoldPriority();
            this._setupPriority = castArg.getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters castArg) {
            this._includeAny = castArg.getIncludeAny();
            this._excludeAny = castArg.getExcludeAny();
            this._includeAll = castArg.getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof RsvpTeObject castArg) {
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes castArg) {
            this._localProtectionDesired = castArg.getLocalProtectionDesired();
            this._labelRecordingDesired = castArg.getLabelRecordingDesired();
            this._seStyleDesired = castArg.getSeStyleDesired();
            this._sessionName = castArg.getSessionName();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Priority, AttributeFilters, RsvpTeObject, TunnelAttributes]");
    }

    private static final class LazyEmpty {
        static final @NonNull BasicSessionAttributeObject INSTANCE = new BasicSessionAttributeObjectBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of BasicSessionAttributeObject.
     *
     * @return An empty {@link BasicSessionAttributeObject}
     */
    public static @NonNull BasicSessionAttributeObject empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getExcludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getHoldPriority()}.
     *
     * @return current value
     */
    public Uint8 getHoldPriority() {
        return _holdPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getIncludeAll()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getIncludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getLabelRecordingDesired()}.
     *
     * @return current value
     */
    public Boolean getLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getLocalProtectionDesired()}.
     *
     * @return current value
     */
    public Boolean getLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getSeStyleDesired()}.
     *
     * @return current value
     */
    public Boolean getSeStyleDesired() {
        return _seStyleDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getSessionName()}.
     *
     * @return current value
     */
    public String getSessionName() {
        return _sessionName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link BasicSessionAttributeObject#getSetupPriority()}.
     *
     * @return current value
     */
    public Uint8 getSetupPriority() {
        return _setupPriority;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BasicSessionAttributeObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getExcludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getHoldPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setHoldPriority(final Uint8 value) {
        this._holdPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getIncludeAll()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getIncludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getLabelRecordingDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setLabelRecordingDesired(final Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getLocalProtectionDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setLocalProtectionDesired(final Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getSeStyleDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setSeStyleDesired(final Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getSessionName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setSessionName(final String value) {
        this._sessionName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link BasicSessionAttributeObject#getSetupPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BasicSessionAttributeObjectBuilder setSetupPriority(final Uint8 value) {
        this._setupPriority = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BasicSessionAttributeObjectBuilder addAugmentation(Augmentation<BasicSessionAttributeObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BasicSessionAttributeObjectBuilder removeAugmentation(Class<? extends Augmentation<BasicSessionAttributeObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link BasicSessionAttributeObject} instance.
     *
     * @return A new {@link BasicSessionAttributeObject} instance.
     */
    public @NonNull BasicSessionAttributeObject build() {
        return new BasicSessionAttributeObjectImpl(this);
    }

    private static final class BasicSessionAttributeObjectImpl
        extends AbstractAugmentable<BasicSessionAttributeObject>
        implements BasicSessionAttributeObject {
    
        private final AttributeFilter _excludeAny;
        private final Uint8 _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _seStyleDesired;
        private final String _sessionName;
        private final Uint8 _setupPriority;
    
        BasicSessionAttributeObjectImpl(BasicSessionAttributeObjectBuilder base) {
            super(base.augmentation);
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._labelRecordingDesired = base.getLabelRecordingDesired();
            this._localProtectionDesired = base.getLocalProtectionDesired();
            this._seStyleDesired = base.getSeStyleDesired();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
        }
    
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public Uint8 getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public Boolean getLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public Boolean getLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public Boolean getSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @Override
        public String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public Uint8 getSetupPriority() {
            return _setupPriority;
        }
    
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = BasicSessionAttributeObject.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return BasicSessionAttributeObject.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return BasicSessionAttributeObject.bindingToString(this);
        }
    }
}
