/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.metric.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.metric.object.MetricObject;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.yang.common.Uint8;

public class MetricObjectBuilder {
    private Boolean _bound;
    private Boolean _computed;
    private Uint8 _metricType;
    private Float32 _value;
    Map<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>> augmentation = Map.of();

    public MetricObjectBuilder() {
    }

    public MetricObjectBuilder(MetricObject base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>>(aug);
        }
        this._bound = base.getBound();
        this._computed = base.getComputed();
        this._metricType = base.getMetricType();
        this._value = base.getValue();
    }

    public static @NonNull MetricObject empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getBound() {
        return this._bound;
    }

    public Boolean getComputed() {
        return this._computed;
    }

    public Uint8 getMetricType() {
        return this._metricType;
    }

    public Float32 getValue() {
        return this._value;
    }

    public <E$$ extends Augmentation<MetricObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MetricObjectBuilder setBound(Boolean value) {
        this._bound = value;
        return this;
    }

    public MetricObjectBuilder setComputed(Boolean value) {
        this._computed = value;
        return this;
    }

    public MetricObjectBuilder setMetricType(Uint8 value) {
        this._metricType = value;
        return this;
    }

    public MetricObjectBuilder setValue(Float32 value) {
        this._value = value;
        return this;
    }

    public MetricObjectBuilder addAugmentation(Augmentation<MetricObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MetricObjectBuilder removeAugmentation(Class<? extends Augmentation<MetricObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MetricObject build() {
        return new MetricObjectImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull MetricObject INSTANCE = new MetricObjectBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MetricObjectImpl
    extends AbstractAugmentable<MetricObject>
    implements MetricObject {
        private final Boolean _bound;
        private final Boolean _computed;
        private final Uint8 _metricType;
        private final Float32 _value;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MetricObjectImpl(MetricObjectBuilder base) {
            super(base.augmentation);
            this._bound = base.getBound();
            this._computed = base.getComputed();
            this._metricType = base.getMetricType();
            this._value = base.getValue();
        }

        @Override
        public Boolean getBound() {
            return this._bound;
        }

        @Override
        public Boolean getComputed() {
            return this._computed;
        }

        @Override
        public Uint8 getMetricType() {
            return this._metricType;
        }

        @Override
        public Float32 getValue() {
            return this._value;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MetricObject.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MetricObject.bindingEquals(this, obj);
        }

        public String toString() {
            return MetricObject.bindingToString(this);
        }
    }
}

