/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RsvpTeObject;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

public interface TspecObject
extends ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject>,
Augmentable<TspecObject>,
RsvpTeObject {
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("tspec-object");

    default public Class<TspecObject> implementedInterface() {
        return TspecObject.class;
    }

    public static int bindingHashCode(@NonNull TspecObject obj) {
        int result = 1;
        int prime = 31;
        result = 31 * result + Objects.hashCode(obj.getMaximumPacketSize());
        result = 31 * result + Objects.hashCode(obj.getMinimumPolicedUnit());
        result = 31 * result + Objects.hashCode(obj.getPeakDataRate());
        result = 31 * result + Objects.hashCode(obj.getTokenBucketRate());
        result = 31 * result + Objects.hashCode(obj.getTokenBucketSize());
        for (Augmentation augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }

    public static boolean bindingEquals(@NonNull TspecObject thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        TspecObject other = (TspecObject)CodeHelpers.checkCast(TspecObject.class, (Object)obj);
        return other != null && Objects.equals(thisObj.getMaximumPacketSize(), other.getMaximumPacketSize()) && Objects.equals(thisObj.getMinimumPolicedUnit(), other.getMinimumPolicedUnit()) && Objects.equals(thisObj.getPeakDataRate(), other.getPeakDataRate()) && Objects.equals(thisObj.getTokenBucketRate(), other.getTokenBucketRate()) && Objects.equals(thisObj.getTokenBucketSize(), other.getTokenBucketSize()) && thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull TspecObject obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TspecObject");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"maximumPacketSize", (Object)obj.getMaximumPacketSize());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"minimumPolicedUnit", (Object)obj.getMinimumPolicedUnit());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"peakDataRate", (Object)obj.getPeakDataRate());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"tokenBucketRate", (Object)obj.getTokenBucketRate());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"tokenBucketSize", (Object)obj.getTokenBucketSize());
        CodeHelpers.appendAugmentations((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Augmentable)obj);
        return helper.toString();
    }

    public Float32 getTokenBucketRate();

    default public @NonNull Float32 requireTokenBucketRate() {
        return (Float32)CodeHelpers.require((Object)this.getTokenBucketRate(), (String)"tokenbucketrate");
    }

    public Float32 getTokenBucketSize();

    default public @NonNull Float32 requireTokenBucketSize() {
        return (Float32)CodeHelpers.require((Object)this.getTokenBucketSize(), (String)"tokenbucketsize");
    }

    public Float32 getPeakDataRate();

    default public @NonNull Float32 requirePeakDataRate() {
        return (Float32)CodeHelpers.require((Object)this.getPeakDataRate(), (String)"peakdatarate");
    }

    public Uint32 getMinimumPolicedUnit();

    default public @NonNull Uint32 requireMinimumPolicedUnit() {
        return (Uint32)CodeHelpers.require((Object)this.getMinimumPolicedUnit(), (String)"minimumpolicedunit");
    }

    public Uint32 getMaximumPacketSize();

    default public @NonNull Uint32 requireMaximumPacketSize() {
        return (Uint32)CodeHelpers.require((Object)this.getMaximumPacketSize(), (String)"maximumpacketsize");
    }
}

