/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.yang.common.Uint32;

public class TspecObjectBuilder {
    private Uint32 _maximumPacketSize;
    private Uint32 _minimumPolicedUnit;
    private Float32 _peakDataRate;
    private Float32 _tokenBucketRate;
    private Float32 _tokenBucketSize;
    Map<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> augmentation = Map.of();

    public TspecObjectBuilder() {
    }

    public TspecObjectBuilder(TspecObject base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>(aug);
        }
        this._maximumPacketSize = base.getMaximumPacketSize();
        this._minimumPolicedUnit = base.getMinimumPolicedUnit();
        this._peakDataRate = base.getPeakDataRate();
        this._tokenBucketRate = base.getTokenBucketRate();
        this._tokenBucketSize = base.getTokenBucketSize();
    }

    public static @NonNull TspecObject empty() {
        return LazyEmpty.INSTANCE;
    }

    public Uint32 getMaximumPacketSize() {
        return this._maximumPacketSize;
    }

    public Uint32 getMinimumPolicedUnit() {
        return this._minimumPolicedUnit;
    }

    public Float32 getPeakDataRate() {
        return this._peakDataRate;
    }

    public Float32 getTokenBucketRate() {
        return this._tokenBucketRate;
    }

    public Float32 getTokenBucketSize() {
        return this._tokenBucketSize;
    }

    public <E$$ extends Augmentation<TspecObject>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TspecObjectBuilder setMaximumPacketSize(Uint32 value) {
        this._maximumPacketSize = value;
        return this;
    }

    public TspecObjectBuilder setMinimumPolicedUnit(Uint32 value) {
        this._minimumPolicedUnit = value;
        return this;
    }

    public TspecObjectBuilder setPeakDataRate(Float32 value) {
        this._peakDataRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketRate(Float32 value) {
        this._tokenBucketRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketSize(Float32 value) {
        this._tokenBucketSize = value;
        return this;
    }

    public TspecObjectBuilder addAugmentation(Augmentation<TspecObject> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TspecObjectBuilder removeAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull TspecObject build() {
        return new TspecObjectImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull TspecObject INSTANCE = new TspecObjectBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class TspecObjectImpl
    extends AbstractAugmentable<TspecObject>
    implements TspecObject {
        private final Uint32 _maximumPacketSize;
        private final Uint32 _minimumPolicedUnit;
        private final Float32 _peakDataRate;
        private final Float32 _tokenBucketRate;
        private final Float32 _tokenBucketSize;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TspecObjectImpl(TspecObjectBuilder base) {
            super(base.augmentation);
            this._maximumPacketSize = base.getMaximumPacketSize();
            this._minimumPolicedUnit = base.getMinimumPolicedUnit();
            this._peakDataRate = base.getPeakDataRate();
            this._tokenBucketRate = base.getTokenBucketRate();
            this._tokenBucketSize = base.getTokenBucketSize();
        }

        @Override
        public Uint32 getMaximumPacketSize() {
            return this._maximumPacketSize;
        }

        @Override
        public Uint32 getMinimumPolicedUnit() {
            return this._minimumPolicedUnit;
        }

        @Override
        public Float32 getPeakDataRate() {
            return this._peakDataRate;
        }

        @Override
        public Float32 getTokenBucketRate() {
            return this._tokenBucketRate;
        }

        @Override
        public Float32 getTokenBucketSize() {
            return this._tokenBucketSize;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = TspecObject.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return TspecObject.bindingEquals(this, obj);
        }

        public String toString() {
            return TspecObject.bindingToString(this);
        }
    }
}

