package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.ErrorSpec.Flags;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;rsvp&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/rsvp.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping error-spec {
 *     leaf node {
 *         type ip-address;
 *     }
 *     leaf flags {
 *         type bits;
 *     }
 *     leaf code {
 *         type uint8;
 *     }
 *     leaf value {
 *         type uint16;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;rsvp/error-spec&lt;/i&gt;
 *
 */
public interface ErrorSpec
    extends
    DataObject
{

    /**
     * The bits built-in type represents a bit set. That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.
     *
     */
    public static final class Flags
     {
        private final java.lang.Boolean _inPlace;
        private final java.lang.Boolean _notGuilty;
    
    
        public Flags(java.lang.Boolean _inPlace, java.lang.Boolean _notGuilty) {
        
        
            this._inPlace = _inPlace;
            this._notGuilty = _notGuilty;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Flags(Flags source) {
            this._inPlace = source._inPlace;
            this._notGuilty = source._notGuilty;
        }
    
    
        public java.lang.Boolean isInPlace() {
            return _inPlace;
        }
        
        public java.lang.Boolean isNotGuilty() {
            return _notGuilty;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_inPlace == null) ? 0 : _inPlace.hashCode());
            result = prime * result + ((_notGuilty == null) ? 0 : _notGuilty.hashCode());
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            Flags other = (Flags) obj;
            if (_inPlace == null) {
                if (other._inPlace != null) {
                    return false;
                }
            } else if(!_inPlace.equals(other._inPlace)) {
                return false;
            }
            if (_notGuilty == null) {
                if (other._notGuilty != null) {
                    return false;
                }
            } else if(!_notGuilty.equals(other._notGuilty)) {
                return false;
            }
            return true;
        }
    
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.ErrorSpec.Flags.class.getSimpleName()).append(" [");
            boolean first = true;
        
            if (_inPlace != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_inPlace=");
                builder.append(_inPlace);
             }
            if (_notGuilty != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_notGuilty=");
                builder.append(_notGuilty);
             }
            return builder.append(']').toString();
        }
    
    
    
    }
    
    


    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:rsvp","2013-08-20","error-spec"));

    IpAddress getNode();
    
    Flags getFlags();
    
    java.lang.Short getCode();
    
    java.lang.Integer getValue();

}

