package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.ExcludeRouteSubobjects.Attribute;


/**
 * Subobject of an Exclude Route Object
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;rsvp&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/rsvp.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping exclude-route-subobjects {
 *     leaf mandatory {
 *         type boolean;
 *     }
 *     leaf attribute {
 *         type enumeration;
 *     }
 *     choice subobject-type {
 *         case as-number-case {
 *             container as-number {
 *                 leaf as-number {
 *                     type as-number;
 *                 }
 *                 uses as-number-subobject;
 *             }
 *         }
 *         case ip-prefix-case {
 *             container ip-prefix {
 *                 leaf ip-prefix {
 *                     type ip-prefix;
 *                 }
 *                 uses ip-prefix-subobject;
 *             }
 *         }
 *         case label-case {
 *             container label {
 *                 leaf uni-directional {
 *                     type boolean;
 *                 }
 *                 choice label-type {
 *                     case generalized-label-case {
 *                         container generalized-label {
 *                             leaf generalized-label {
 *                                 type binary;
 *                             }
 *                             uses generalized-label;
 *                         }
 *                     }
 *                     case type1-label-case {
 *                         container type1-label {
 *                             leaf type1-label {
 *                                 type uint32;
 *                             }
 *                             uses type1-label;
 *                         }
 *                     }
 *                     case waveband-switching-label-case {
 *                         container waveband-switching-label {
 *                             leaf end-label {
 *                                 type uint32;
 *                             }
 *                             leaf start-label {
 *                                 type uint32;
 *                             }
 *                             leaf waveband-id {
 *                                 type uint32;
 *                             }
 *                             uses waveband-switching-label;
 *                         }
 *                     }
 *                 }
 *                 uses label-subobject;
 *             }
 *         }
 *         case srlg-case {
 *             container srlg {
 *                 leaf srlg-id {
 *                     type srlg-id;
 *                 }
 *                 uses srlg-subobject;
 *             }
 *         }
 *         case unnumbered-case {
 *             container unnumbered {
 *                 leaf router-id {
 *                     type uint32;
 *                 }
 *                 leaf interface-id {
 *                     type uint32;
 *                 }
 *                 uses unnumbered-subobject;
 *             }
 *         }
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;rsvp/exclude-route-subobjects&lt;/i&gt;
 *
 */
public interface ExcludeRouteSubobjects
    extends
    DataObject,
    BasicExplicitRouteSubobjects
{


    /**
     * The enumeration built-in type represents values from a set of assigned names.
     *
     */
    public enum Attribute {
        Interface(0),
        
        Node(1),
        
        Srlg(2)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, Attribute> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Attribute> b = com.google.common.collect.ImmutableMap.builder();
            for (Attribute enumItem : Attribute.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private Attribute(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding Attribute item
         */
        public static Attribute forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:rsvp","2013-08-20","exclude-route-subobjects"));

    java.lang.Boolean isMandatory();
    
    Attribute getAttribute();

}

