package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.LabelSet.Action;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.label.set.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.label.set.Subchannels;
import java.util.List;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;rsvp&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/rsvp.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping label-set {
 *     leaf action {
 *         type enumeration;
 *     }
 *     container label-type {
 *     }
 *     list subchannels {
 *         key }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;rsvp/label-set&lt;/i&gt;
 *
 */
public interface LabelSet
    extends
    DataObject
{


    /**
     * The enumeration built-in type represents values from a set of assigned names.
     *
     */
    public enum Action {
        InclusiveList(0),
        
        ExclusiveList(1),
        
        InclusiveRange(2),
        
        ExclusiveRange(3)
        ;
    
    
        int value;
        private static final java.util.Map<java.lang.Integer, Action> VALUE_MAP;
    
        static {
            final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, Action> b = com.google.common.collect.ImmutableMap.builder();
            for (Action enumItem : Action.values())
            {
                b.put(enumItem.value, enumItem);
            }
    
            VALUE_MAP = b.build();
        }
    
        private Action(int value) {
            this.value = value;
        }
    
        /**
         * @return integer value
         */
        public int getIntValue() {
            return value;
        }
    
        /**
         * @param valueArg
         * @return corresponding Action item
         */
        public static Action forValue(int valueArg) {
            return VALUE_MAP.get(valueArg);
        }
    }

    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:rsvp","2013-08-20","label-set"));

    Action getAction();
    
    LabelType getLabelType();
    
    List<Subchannels> getSubchannels();

}

