package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;rsvp&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/rsvp.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping tunnel-attributes {
 *     leaf hold-priority {
 *         type uint8;
 *     }
 *     leaf setup-priority {
 *         type uint8;
 *     }
 *     leaf local-protection-desired {
 *         type boolean;
 *     }
 *     leaf include-any {
 *         type attribute-filter;
 *     }
 *     leaf exclude-any {
 *         type attribute-filter;
 *     }
 *     leaf include-all {
 *         type attribute-filter;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;rsvp/tunnel-attributes&lt;/i&gt;
 *
 */
public interface TunnelAttributes
    extends
    DataObject,
    AttributeFilters
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:rsvp","2013-08-20","tunnel-attributes"));

    java.lang.Short getHoldPriority();
    
    java.lang.Short getSetupPriority();
    
    java.lang.Boolean isLocalProtectionDesired();

}

