/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.util.concurrent.Future;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class CheckUtil {
    private static final int SLEEP_FOR = 200;
    private static final int TIMEOUT = 30;

    private CheckUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Future<?>> void waitFutureSuccess(T future) {
        CheckUtil.waitFutureSuccess(future, 200L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    static <T extends Future<?>> void waitFutureSuccess(T future, long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        future.addListener(future1 -> latch.countDown());
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)timeout, (TimeUnit)unit);
        Verify.verify((boolean)future.isSuccess());
    }

    public static <R, T extends DataObject> R readDataOperational(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function) throws InterruptedException, ExecutionException {
        return CheckUtil.readDataOperational(dataBroker, iid, function, 30);
    }

    @VisibleForTesting
    static <R, T extends DataObject> R readDataOperational(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws InterruptedException, ExecutionException {
        return CheckUtil.readData(dataBroker, LogicalDatastoreType.OPERATIONAL, iid, function, timeout);
    }

    public static <R, T extends DataObject> R readDataConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function) throws InterruptedException, ExecutionException {
        return CheckUtil.readDataConfiguration(dataBroker, iid, function, 30);
    }

    @VisibleForTesting
    static <R, T extends DataObject> R readDataConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws InterruptedException, ExecutionException {
        return CheckUtil.readData(dataBroker, LogicalDatastoreType.CONFIGURATION, iid, function, timeout);
    }

    private static <R, T extends DataObject> R readData(DataBroker dataBroker, LogicalDatastoreType ldt, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws InterruptedException, ExecutionException {
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        do {
            Throwable throwable = null;
            try (ReadTransaction tx = dataBroker.newReadOnlyTransaction();){
                R r;
                Optional data = (Optional)tx.read(ldt, iid).get();
                if (!data.isPresent()) continue;
                try {
                    r = function.apply(data.get());
                }
                catch (AssertionError e) {
                    try {
                        lastError = e;
                        Uninterruptibles.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
                return r;
            }
        } while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout);
        throw lastError;
    }

    public static <T extends DataObject> T checkPresentOperational(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        return (T)CheckUtil.readData(dataBroker, LogicalDatastoreType.OPERATIONAL, iid, bgpRib -> bgpRib, 30);
    }

    public static <T extends DataObject> T checkPresentConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        return (T)CheckUtil.readData(dataBroker, LogicalDatastoreType.CONFIGURATION, iid, bgpRib -> bgpRib, 30);
    }

    public static <T extends DataObject> void checkNotPresentOperational(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        CheckUtil.checkNotPresent(dataBroker, LogicalDatastoreType.OPERATIONAL, iid);
    }

    public static <T extends DataObject> void checkNotPresentConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        CheckUtil.checkNotPresent(dataBroker, LogicalDatastoreType.CONFIGURATION, iid);
    }

    /*
     * Exception decompiling
     */
    private static <T extends DataObject> void checkNotPresent(DataBroker dataBroker, LogicalDatastoreType ldt, InstanceIdentifier<T> iid) throws InterruptedException, ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkEquals(CheckEquals function) throws Exception {
        CheckUtil.checkEquals(function, 30);
    }

    public static void checkEquals(CheckEquals function, int timeout) throws Exception {
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout) {
            try {
                function.check();
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        throw lastError;
    }

    public static void checkReceivedMessages(ListenerCheck listener, int numberOfMessages) {
        CheckUtil.checkReceivedMessages(listener, numberOfMessages, 30);
    }

    @VisibleForTesting
    static void checkReceivedMessages(ListenerCheck listener, int numberOfMessages, int timeout) {
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout) {
            if (listener.getListMessageSize() != numberOfMessages) {
                Uninterruptibles.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            return;
        }
        throw new AssertionError((Object)("Expected " + numberOfMessages + " but received " + listener.getListMessageSize()));
    }

    @FunctionalInterface
    public static interface CheckEquals {
        public void check() throws ExecutionException, InterruptedException;
    }

    public static interface ListenerCheck {
        public int getListMessageSize();
    }
}

