/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.VerifyException;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.protocol.util.CheckUtil;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class CheckUtilTest
extends AbstractConcurrentDataBrokerTest {
    private static final TopologyId TOPOLOGY_ID = new TopologyId("topotest");
    private static final KeyedInstanceIdentifier<Topology, TopologyKey> TOPOLOGY_IID = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Key)new TopologyKey(TOPOLOGY_ID));
    private static final int TIMEOUT = 1;
    @Mock
    private CheckUtil.ListenerCheck listenerCheck;
    @Mock
    private ChannelFuture future;

    @Test
    public void testWaitFutureSuccessFail() {
        ((ChannelFuture)Mockito.doReturn((Object)this.future).when((Object)this.future)).addListener((GenericFutureListener)ArgumentMatchers.any());
        Assert.assertThrows(VerifyException.class, () -> CheckUtil.waitFutureSuccess((Future)this.future, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @Test
    public void testWaitFutureSuccess() {
        Mockito.when((Object)this.future.isSuccess()).thenReturn((Object)true);
        ((ChannelFuture)Mockito.doAnswer(invocation -> {
            ((GenericFutureListener)invocation.getArgument(0, GenericFutureListener.class)).operationComplete((Future)this.future);
            return this.future;
        }).when((Object)this.future)).addListener((GenericFutureListener)ArgumentMatchers.any());
        CheckUtil.waitFutureSuccess((Future)this.future);
    }

    @Test
    public void testReadDataOperationalNull() {
        Assert.assertThrows(AssertionError.class, () -> CheckUtil.readDataOperational((DataBroker)this.getDataBroker(), TOPOLOGY_IID, test -> false, (int)1));
    }

    public void testReadDataConfigurationNull() {
        Assert.assertThrows(AssertionError.class, () -> CheckUtil.readDataConfiguration((DataBroker)this.getDataBroker(), TOPOLOGY_IID, test -> false, (int)1));
    }

    public void testReadDataOperationalFail() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        Assert.assertThrows(AssertionError.class, () -> CheckUtil.readDataOperational((DataBroker)this.getDataBroker(), TOPOLOGY_IID, result -> {
            Assert.assertNotNull((Object)result.getNode());
            return result;
        }, (int)1));
    }

    public void testReadDataConfigurationFail() throws Exception {
        this.storeTopo(LogicalDatastoreType.CONFIGURATION);
        Assert.assertThrows(AssertionError.class, () -> CheckUtil.readDataConfiguration((DataBroker)this.getDataBroker(), TOPOLOGY_IID, result -> {
            Assert.assertNotNull((Object)result.getNode());
            return result;
        }, (int)1));
    }

    @Test
    public void testReadDataOperational() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        CheckUtil.readDataOperational((DataBroker)this.getDataBroker(), TOPOLOGY_IID, result -> {
            Assert.assertNull((Object)result.getNode());
            return result;
        }, (int)1);
    }

    @Test
    public void testReadDataConfiguration() throws Exception {
        this.storeTopo(LogicalDatastoreType.CONFIGURATION);
        CheckUtil.readDataConfiguration((DataBroker)this.getDataBroker(), TOPOLOGY_IID, result -> {
            Assert.assertNull((Object)result.getNode());
            return result;
        }, (int)1);
    }

    private void storeTopo(LogicalDatastoreType dsType) throws ExecutionException, InterruptedException {
        WriteTransaction wt = this.getDataBroker().newWriteOnlyTransaction();
        wt.mergeParentStructurePut(dsType, TOPOLOGY_IID, (DataObject)new TopologyBuilder().setTopologyId(TOPOLOGY_ID).build());
        wt.commit().get();
    }

    @Test
    public void testCheckPresentConfiguration() throws Exception {
        this.storeTopo(LogicalDatastoreType.CONFIGURATION);
        CheckUtil.checkPresentConfiguration((DataBroker)this.getDataBroker(), TOPOLOGY_IID);
    }

    @Test
    public void testCheckPresentOperational() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        CheckUtil.checkPresentOperational((DataBroker)this.getDataBroker(), TOPOLOGY_IID);
    }

    @Test
    public void testCheckNotPresentOperationalFail() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        Assert.assertThrows(AssertionError.class, () -> CheckUtil.checkNotPresentOperational((DataBroker)this.getDataBroker(), TOPOLOGY_IID));
    }

    @Test
    public void testCheckNotPresentOperational() throws Exception {
        CheckUtil.checkNotPresentOperational((DataBroker)this.getDataBroker(), TOPOLOGY_IID);
    }

    @Test
    public void testCheckNotPresentConfiguration() throws Exception {
        CheckUtil.checkNotPresentConfiguration((DataBroker)this.getDataBroker(), TOPOLOGY_IID);
    }

    @Test
    public void testCheckEquals() throws Exception {
        Assert.assertThrows(AssertionError.class, () -> CheckUtil.checkEquals(Assert::fail, (int)1));
    }

    @Test
    public void testCheckReceivedMessagesNotEqual() {
        ((CheckUtil.ListenerCheck)Mockito.doReturn((Object)0).when((Object)this.listenerCheck)).getListMessageSize();
        Assert.assertThrows(AssertionError.class, () -> CheckUtil.checkReceivedMessages((CheckUtil.ListenerCheck)this.listenerCheck, (int)1, (int)1));
    }

    @Test
    public void testCheckReceivedMessagesEqual() {
        ((CheckUtil.ListenerCheck)Mockito.doReturn((Object)1).when((Object)this.listenerCheck)).getListMessageSize();
        CheckUtil.checkReceivedMessages((CheckUtil.ListenerCheck)this.listenerCheck, (int)1, (int)1);
    }
}

