/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.VerifyException;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.protocol.util.CheckUtil;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyBuilder;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public class CheckUtilTest
extends AbstractConcurrentDataBrokerTest {
    private static final TopologyId TOPOLOGY_ID = new TopologyId("topotest");
    private final KeyedInstanceIdentifier<Topology, TopologyKey> topologyIIdKeyed = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(TOPOLOGY_ID));
    private static int TIMEOUT = 1;
    @Mock
    private CheckUtil.ListenerCheck listenerCheck;
    @Mock
    private ChannelFuture future;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
    }

    @Test(expected=VerifyException.class)
    public void testWaitFutureSuccessFail() throws Exception {
        Mockito.when((Object)this.future.isDone()).thenReturn((Object)false);
        ((ChannelFuture)Mockito.doReturn((Object)this.future).when((Object)this.future)).addListener((GenericFutureListener)Matchers.any());
        CheckUtil.waitFutureSuccess((Future)this.future);
    }

    @Test
    public void testWaitFutureSuccess() throws Exception {
        Mockito.when((Object)this.future.isSuccess()).thenReturn((Object)true);
        ((ChannelFuture)Mockito.doAnswer(invocation -> {
            ((GenericFutureListener)invocation.getArgumentAt(0, GenericFutureListener.class)).operationComplete((Future)this.future);
            return this.future;
        }).when((Object)this.future)).addListener((GenericFutureListener)Matchers.any());
        CheckUtil.waitFutureSuccess((Future)this.future);
    }

    @Test(expected=NullPointerException.class)
    public void testReadDataOperationalNull() throws Exception {
        CheckUtil.readDataOperational((DataBroker)this.getDataBroker(), this.topologyIIdKeyed, test -> false, (int)TIMEOUT);
    }

    @Test(expected=NullPointerException.class)
    public void testReadDataConfigurationNull() throws Exception {
        CheckUtil.readDataConfiguration((DataBroker)this.getDataBroker(), this.topologyIIdKeyed, test -> false, (int)TIMEOUT);
    }

    @Test(expected=AssertionError.class)
    public void testReadDataOperationalFail() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        CheckUtil.readDataOperational((DataBroker)this.getDataBroker(), this.topologyIIdKeyed, result -> {
            Assert.assertNotNull((Object)result.getNode());
            return result;
        }, (int)TIMEOUT);
    }

    @Test(expected=AssertionError.class)
    public void testReadDataConfigurationFail() throws Exception {
        this.storeTopo(LogicalDatastoreType.CONFIGURATION);
        CheckUtil.readDataConfiguration((DataBroker)this.getDataBroker(), this.topologyIIdKeyed, result -> {
            Assert.assertNotNull((Object)result.getNode());
            return result;
        }, (int)TIMEOUT);
    }

    @Test
    public void testReadDataOperational() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        CheckUtil.readDataOperational((DataBroker)this.getDataBroker(), this.topologyIIdKeyed, result -> {
            TestCase.assertNull((Object)result.getNode());
            return result;
        }, (int)TIMEOUT);
    }

    @Test
    public void testReadDataConfiguration() throws Exception {
        this.storeTopo(LogicalDatastoreType.CONFIGURATION);
        CheckUtil.readDataConfiguration((DataBroker)this.getDataBroker(), this.topologyIIdKeyed, result -> {
            TestCase.assertNull((Object)result.getNode());
            return result;
        }, (int)TIMEOUT);
    }

    private void storeTopo(LogicalDatastoreType dsType) throws ExecutionException, InterruptedException {
        WriteTransaction wt = this.getDataBroker().newWriteOnlyTransaction();
        wt.put(dsType, this.topologyIIdKeyed, (DataObject)new TopologyBuilder().setTopologyId(TOPOLOGY_ID).build(), true);
        wt.submit().get();
    }

    @Test
    public void testCheckPresentConfiguration() throws Exception {
        this.storeTopo(LogicalDatastoreType.CONFIGURATION);
        CheckUtil.checkPresentConfiguration((DataBroker)this.getDataBroker(), this.topologyIIdKeyed);
    }

    @Test
    public void testCheckPresentOperational() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        CheckUtil.checkPresentOperational((DataBroker)this.getDataBroker(), this.topologyIIdKeyed);
    }

    @Test(expected=AssertionError.class)
    public void testCheckNotPresentOperationalFail() throws Exception {
        this.storeTopo(LogicalDatastoreType.OPERATIONAL);
        CheckUtil.checkNotPresentOperational((DataBroker)this.getDataBroker(), this.topologyIIdKeyed);
    }

    @Test
    public void testCheckNotPresentOperational() throws Exception {
        CheckUtil.checkNotPresentOperational((DataBroker)this.getDataBroker(), this.topologyIIdKeyed);
    }

    @Test
    public void testCheckNotPresentConfiguration() throws Exception {
        CheckUtil.checkNotPresentConfiguration((DataBroker)this.getDataBroker(), this.topologyIIdKeyed);
    }

    @Test(expected=AssertionError.class)
    public void testCheckEquals() throws Exception {
        CheckUtil.checkEquals(() -> Assert.assertTrue((boolean)false), (int)TIMEOUT);
    }

    @Test(expected=AssertionError.class)
    public void testCheckReceivedMessagesNotEqual() throws Exception {
        ((CheckUtil.ListenerCheck)Mockito.doReturn((Object)0).when((Object)this.listenerCheck)).getListMessageSize();
        CheckUtil.checkReceivedMessages((CheckUtil.ListenerCheck)this.listenerCheck, (int)1, (int)TIMEOUT);
    }

    @Test
    public void testCheckReceivedMessagesEqual() throws Exception {
        ((CheckUtil.ListenerCheck)Mockito.doReturn((Object)1).when((Object)this.listenerCheck)).getListMessageSize();
        CheckUtil.checkReceivedMessages((CheckUtil.ListenerCheck)this.listenerCheck, (int)1, (int)TIMEOUT);
    }
}

