/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.net.HostAndPort;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.util.InetSocketAddressUtil;

public class InetSocketAddressUtilTest {
    private static final String ADDRESS1 = "1.1.1.1";
    private static final String ADDRESS2 = "2.2.2.2";
    private static final int PORT1 = 123;
    private static final int PORT2 = 321;
    private static final String ADDRESSES_WO_PORT = "1.1.1.1,2.2.2.2";
    private static final String ADDRESSES = "1.1.1.1:123,2.2.2.2:321";
    private static final int DEFAULT_PORT = 179;

    @Test(expected=UnsupportedOperationException.class)
    public void testPrivateConstructor() throws Throwable {
        Constructor c = InetSocketAddressUtil.class.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        try {
            c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @Test
    public void parseAddresses() throws Exception {
        List actualResult = InetSocketAddressUtil.parseAddresses((String)ADDRESSES, (int)179);
        Assert.assertEquals(Arrays.asList(new InetSocketAddress(ADDRESS1, 123), new InetSocketAddress(ADDRESS2, 321)), (Object)actualResult);
    }

    @Test
    public void toHostAndPort() throws Exception {
        HostAndPort actualResult = InetSocketAddressUtil.toHostAndPort((InetSocketAddress)new InetSocketAddress(ADDRESS2, 321));
        HostAndPort expected = HostAndPort.fromString((String)"2.2.2.2:321");
        Assert.assertEquals((Object)expected, (Object)actualResult);
    }

    @Test
    public void parseAddressesDefaultPort() throws Exception {
        List actualResult = InetSocketAddressUtil.parseAddresses((String)ADDRESSES_WO_PORT, (int)179);
        List<InetSocketAddress> expected = Arrays.asList(new InetSocketAddress(ADDRESS1, 179), new InetSocketAddress(ADDRESS2, 179));
        Assert.assertEquals(expected, (Object)actualResult);
    }

    @Test
    public void parseAddressesWithoutPort() throws Exception {
        List actualResult = InetSocketAddressUtil.parseAddresses((String)ADDRESSES);
        Assert.assertEquals(Arrays.asList(new InetSocketAddress(ADDRESS1, 123), new InetSocketAddress(ADDRESS2, 321)), (Object)actualResult);
    }

    @Test
    public void getInetSocketAddress() throws Exception {
        Assert.assertEquals((Object)new InetSocketAddress(ADDRESS1, 123), (Object)InetSocketAddressUtil.getInetSocketAddress((String)"1.1.1.1:123", (Integer)179));
        Assert.assertEquals((Object)new InetSocketAddress(ADDRESS1, 179), (Object)InetSocketAddressUtil.getInetSocketAddress((String)ADDRESS1, (Integer)179));
    }

    @Test
    public void getRandomLoopbackInetSocketAddressTest() throws Exception {
        InetSocketAddress addr1 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress();
        InetSocketAddress addr2 = InetSocketAddressUtil.getRandomLoopbackInetSocketAddress();
        Assert.assertNotNull((Object)addr1);
        Assert.assertNotNull((Object)addr2);
        Assert.assertNotEquals((Object)addr1, (Object)addr2);
        Assert.assertNotEquals((Object)addr1.getHostString(), (Object)addr2.getHostString());
        Assert.assertNotEquals((long)addr1.getPort(), (long)addr2.getPort());
    }
}

