/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.topology;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.bgpcep.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkTopologyConfigFileProcessor
implements ConfigFileProcessor,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkTopologyConfigFileProcessor.class);
    private static final SchemaPath TOPOLOGY_SCHEMA_PATH = SchemaPath.create((boolean)true, (QName)NetworkTopology.QNAME);
    private final BindingNormalizedNodeSerializer bindingSerializer;
    private AbstractRegistration registration;
    private final YangInstanceIdentifier topologyYii;
    private static final InstanceIdentifier<Topology> TOPOLOGY_IID = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class);
    private final DataBroker dataBroker;
    private final ConfigLoader configLoader;

    public NetworkTopologyConfigFileProcessor(ConfigLoader configLoader, DataBroker dataBroker) {
        Objects.requireNonNull(configLoader);
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.configLoader = Objects.requireNonNull(configLoader);
        this.bindingSerializer = configLoader.getBindingNormalizedNodeSerializer();
        this.topologyYii = this.bindingSerializer.toYangInstanceIdentifier(TOPOLOGY_IID);
    }

    public synchronized void init() {
        this.registration = this.configLoader.registerConfigFile((ConfigFileProcessor)this);
        LOG.info("Network Topology Loader service initiated");
    }

    @Override
    public synchronized void close() {
        if (this.registration != null) {
            this.registration.close();
            this.registration = null;
        }
    }

    public SchemaPath getSchemaPath() {
        return TOPOLOGY_SCHEMA_PATH;
    }

    public synchronized void loadConfiguration(NormalizedNode<?, ?> dto) {
        ContainerNode networkTopologyContainer = (ContainerNode)dto;
        MapNode topologyList = (MapNode)networkTopologyContainer.getChild(this.topologyYii.getLastPathArgument()).get();
        Collection networkTopology = topologyList.getValue();
        if (networkTopology.isEmpty()) {
            return;
        }
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        for (MapEntryNode topologyEntry : networkTopology) {
            Map.Entry bi = this.bindingSerializer.fromNormalizedNode(this.topologyYii, (NormalizedNode)topologyEntry);
            if (bi == null) continue;
            NetworkTopologyConfigFileProcessor.processTopology((Topology)bi.getValue(), wtx);
        }
        try {
            wtx.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to create Network Topologies", (Throwable)e);
        }
    }

    private static void processTopology(Topology topology, WriteTransaction wtx) {
        LOG.info("Storing Topology {}", (Object)topology);
        KeyedInstanceIdentifier topologyIIdKeyed = InstanceIdentifier.create(NetworkTopology.class).child(Topology.class, (Identifier)topology.key());
        wtx.mergeParentStructureMerge(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)topologyIIdKeyed, (DataObject)topology);
    }
}

