/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.topology;

import com.google.common.util.concurrent.FluentFuture;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.bgpcep.config.loader.spi.AbstractConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class NetworkTopologyConfigFileProcessor
extends AbstractConfigFileProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkTopologyConfigFileProcessor.class);

    @Inject
    public NetworkTopologyConfigFileProcessor(ConfigLoader configLoader, DOMDataBroker dataBroker) {
        super("Network Topology", configLoader, dataBroker);
    }

    @PostConstruct
    public void init() {
        this.start();
    }

    @PreDestroy
    public void close() {
        this.stop();
    }

    public SchemaNodeIdentifier.Absolute fileRootSchema() {
        return SchemaNodeIdentifier.Absolute.of((QName)NetworkTopology.QNAME);
    }

    protected FluentFuture<? extends CommitInfo> loadConfiguration(DOMDataBroker dataBroker, NormalizedNode dto) {
        ContainerNode networkTopology = (ContainerNode)dto;
        MapNode topologies = (MapNode)networkTopology.childByArg((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Topology.QNAME));
        if (networkTopology == null) {
            return CommitInfo.emptyFluentFuture();
        }
        DOMDataTreeWriteTransaction wtx = dataBroker.newWriteOnlyTransaction();
        LOG.info("Storing Topologies {}", topologies.body().stream().map(topo -> topo.name().asMap()).collect(Collectors.toList()));
        wtx.merge(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{new YangInstanceIdentifier.NodeIdentifier(NetworkTopology.QNAME), topologies.name()}), (NormalizedNode)topologies);
        return wtx.commit();
    }
}

