/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.adjacency._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.adjacency._case.Adjacency;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AdjacencyBuilder
implements Builder<Adjacency> {
    private LinkId _adjacency;
    Map<Class<? extends Augmentation<Adjacency>>, Augmentation<Adjacency>> augmentation = Collections.emptyMap();

    public AdjacencyBuilder() {
    }

    public AdjacencyBuilder(Adjacency base) {
        Map aug;
        this._adjacency = base.getAdjacency();
        if (base instanceof AdjacencyImpl) {
            AdjacencyImpl impl = (AdjacencyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Adjacency>>, Augmentation<Adjacency>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Adjacency>>, Augmentation<Adjacency>>(aug);
        }
    }

    public LinkId getAdjacency() {
        return this._adjacency;
    }

    public <E extends Augmentation<Adjacency>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public AdjacencyBuilder setAdjacency(LinkId value) {
        this._adjacency = value;
        return this;
    }

    public AdjacencyBuilder addAugmentation(Class<? extends Augmentation<Adjacency>> augmentationType, Augmentation<Adjacency> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Adjacency>>, Augmentation<Adjacency>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AdjacencyBuilder removeAugmentation(Class<? extends Augmentation<Adjacency>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Adjacency build() {
        return new AdjacencyImpl(this);
    }

    private static final class AdjacencyImpl
    implements Adjacency {
        private final LinkId _adjacency;
        private Map<Class<? extends Augmentation<Adjacency>>, Augmentation<Adjacency>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        AdjacencyImpl(AdjacencyBuilder base) {
            this._adjacency = base.getAdjacency();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Adjacency> getImplementedInterface() {
            return Adjacency.class;
        }

        @Override
        public LinkId getAdjacency() {
            return this._adjacency;
        }

        public <E extends Augmentation<Adjacency>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._adjacency);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Adjacency.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Adjacency other = (Adjacency)obj;
            if (!Objects.equals(this._adjacency, other.getAdjacency())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AdjacencyImpl otherImpl = (AdjacencyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Adjacency>>, Augmentation<Adjacency>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Adjacency");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_adjacency", (Object)this._adjacency);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

