/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SegmentId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.SegmentsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.SegmentSpecification;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SegmentsBuilder
implements Builder<Segments> {
    private SegmentId _segmentId;
    private SegmentSpecification _segmentSpecification;
    private SegmentsKey key;
    Map<Class<? extends Augmentation<Segments>>, Augmentation<Segments>> augmentation = Collections.emptyMap();

    public SegmentsBuilder() {
    }

    public SegmentsBuilder(Segments base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Segments>>, Augmentation<Segments>>(aug);
        }
        this.key = base.key();
        this._segmentId = base.getSegmentId();
        this._segmentSpecification = base.getSegmentSpecification();
    }

    public SegmentsKey key() {
        return this.key;
    }

    public SegmentId getSegmentId() {
        return this._segmentId;
    }

    public SegmentSpecification getSegmentSpecification() {
        return this._segmentSpecification;
    }

    public <E$$ extends Augmentation<Segments>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public SegmentsBuilder withKey(SegmentsKey key) {
        this.key = key;
        return this;
    }

    public SegmentsBuilder setSegmentId(SegmentId value) {
        this._segmentId = value;
        return this;
    }

    public SegmentsBuilder setSegmentSpecification(SegmentSpecification value) {
        this._segmentSpecification = value;
        return this;
    }

    public SegmentsBuilder addAugmentation(Class<? extends Augmentation<Segments>> augmentationType, Augmentation<Segments> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Segments>>, Augmentation<Segments>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SegmentsBuilder removeAugmentation(Class<? extends Augmentation<Segments>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Segments build() {
        return new SegmentsImpl(this);
    }

    private static final class SegmentsImpl
    extends AbstractAugmentable<Segments>
    implements Segments {
        private final SegmentId _segmentId;
        private final SegmentSpecification _segmentSpecification;
        private final SegmentsKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SegmentsImpl(SegmentsBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SegmentsKey(base.getSegmentId());
            this._segmentId = this.key.getSegmentId();
            this._segmentSpecification = base.getSegmentSpecification();
        }

        @Override
        public SegmentsKey key() {
            return this.key;
        }

        @Override
        public SegmentId getSegmentId() {
            return this._segmentId;
        }

        @Override
        public SegmentSpecification getSegmentSpecification() {
            return this._segmentSpecification;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._segmentId);
            result = 31 * result + Objects.hashCode(this._segmentSpecification);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Segments.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Segments other = (Segments)obj;
            if (!Objects.equals(this._segmentId, other.getSegmentId())) {
                return false;
            }
            if (!Objects.equals(this._segmentSpecification, other.getSegmentSpecification())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SegmentsImpl otherImpl = (SegmentsImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Segments");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_segmentId", (Object)this._segmentId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_segmentSpecification", (Object)this._segmentSpecification);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

