package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.topology.sr.type.TopologySr;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-sr</b>
 * <pre>
 * grouping topology-sr-type {
 *   container topology-sr {
 *     presence "indicates a Segment Routing-aware topology";
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-sr/topology-sr-type</i>
 *
 */
public interface TopologySrType
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("topology-sr-type");

    @Override
    Class<? extends TopologySrType> implementedInterface();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.topology.sr.type.TopologySr</code> <code>topologySr</code>, or <code>null</code> if not present
     */
    @Nullable TopologySr getTopologySr();

}

