package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819.tunnel.sr.type.SrTunnel;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PathTypes1Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PathTypes1Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new PathTypes1BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PathTypes1Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PathTypes1Builder
 * @see Builder
 *
 */
public class PathTypes1Builder implements Builder<PathTypes1> {

    private SrTunnel _srTunnel;



    public PathTypes1Builder() {
    }
    public PathTypes1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819.TunnelSrType arg) {
        this._srTunnel = arg.getSrTunnel();
    }

    public PathTypes1Builder(PathTypes1 base) {
        this._srTunnel = base.getSrTunnel();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819.TunnelSrType</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819.TunnelSrType) {
            this._srTunnel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819.TunnelSrType)arg).getSrTunnel();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819.TunnelSrType]");
    }

    public SrTunnel getSrTunnel() {
        return _srTunnel;
    }

    
    public PathTypes1Builder setSrTunnel(final SrTunnel value) {
        this._srTunnel = value;
        return this;
    }
    

    @Override
    public PathTypes1 build() {
        return new PathTypes1Impl(this);
    }

    private static final class PathTypes1Impl
        implements PathTypes1 {
    
        private final SrTunnel _srTunnel;
    
        PathTypes1Impl(PathTypes1Builder base) {
            this._srTunnel = base.getSrTunnel();
        }
    
        @Override
        public SrTunnel getSrTunnel() {
            return _srTunnel;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_srTunnel);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathTypes1.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            PathTypes1 other = (PathTypes1)obj;
            if (!Objects.equals(_srTunnel, other.getSrTunnel())) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PathTypes1");
            CodeHelpers.appendValue(helper, "_srTunnel", _srTunnel);
            return helper.toString();
        }
    }
}
