package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819;
import java.lang.Class;
import java.lang.Override;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.SegmentsKey;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-sr</b>
 * <pre>
 * grouping sr-node-attributes {
 *   list segments {
 *     leaf segment-id {
 *       type segment-id;
 *     }
 *     key segment-id;
 *     choice segment-specification {
 *       case adjacency-case {
 *         container adjacency {
 *           leaf adjacency {
 *             type nt:link-ref;
 *           }
 *         }
 *       }
 *       case prefix-case {
 *         container prefix {
 *           leaf prefix {
 *             type inet:ip-prefix;
 *           }
 *           leaf node-sid {
 *             type boolean;
 *             default false;
 *           }
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-sr/sr-node-attributes</i>
 *
 */
public interface SrNodeAttributes
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("sr-node-attributes");

    @Override
    Class<? extends SrNodeAttributes> implementedInterface();
    
    /**
     * @return <code>java.util.Map</code> <code>segments</code>, or <code>null</code> if not present
     */
    @Nullable Map<SegmentsKey, Segments> getSegments();
    
    /**
     * @return <code>java.util.Map</code> <code>segments</code>, or an empty list if it is not present
     */
    default @NonNull Map<SegmentsKey, Segments> nonnullSegments() {
        return CodeHelpers.nonnull(getSegments());
    }

}

