package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes;
import java.lang.Class;
import java.lang.Override;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SegmentId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SrNodeAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.SegmentSpecification;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-sr</b>
 * <pre>
 * list segments {
 *   leaf segment-id {
 *     type segment-id;
 *   }
 *   key segment-id;
 *   choice segment-specification {
 *     case adjacency-case {
 *       container adjacency {
 *         leaf adjacency {
 *           type nt:link-ref;
 *         }
 *       }
 *     }
 *     case prefix-case {
 *       container prefix {
 *         leaf prefix {
 *           type inet:ip-prefix;
 *         }
 *         leaf node-sid {
 *           type boolean;
 *           default false;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>network-topology-sr/sr-node-attributes/segments</i>
 *
 * <p>To create instances of this class use {@link SegmentsBuilder}.
 * @see SegmentsBuilder
 * @see SegmentsKey
 *
 */
public interface Segments
    extends
    ChildOf<SrNodeAttributes>,
    Augmentable<Segments>,
    Identifiable<SegmentsKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("segments");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments.class;
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SegmentId</code> <code>segmentId</code>, or <code>null</code> if not present
     */
    SegmentId getSegmentId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.SegmentSpecification</code> <code>segmentSpecification</code>, or <code>null</code> if not present
     */
    SegmentSpecification getSegmentSpecification();
    
    @Override
    SegmentsKey key();

}

