package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Link1Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Link1Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new Link1BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Link1Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Link1Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Link1Builder implements Builder<Link1> {

    private SegmentId _segment;



    public Link1Builder() {
    }
    
    
    public Link1Builder(SrLinkAttributes arg) {
        this._segment = arg.getSegment();
    }

    public Link1Builder(Link1 base) {
        this._segment = base.getSegment();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SrLinkAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrLinkAttributes) {
            this._segment = ((SrLinkAttributes)arg).getSegment();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SrLinkAttributes]");
    }

    public SegmentId getSegment() {
        return _segment;
    }

    
    public Link1Builder setSegment(final SegmentId value) {
        this._segment = value;
        return this;
    }
    

    @Override
    public Link1 build() {
        return new Link1Impl(this);
    }

    private static final class Link1Impl
        implements Link1 {
    
        private final SegmentId _segment;
    
        Link1Impl(Link1Builder base) {
            this._segment = base.getSegment();
        }
    
        @Override
        public SegmentId getSegment() {
            return _segment;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Link1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Link1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Link1.bindingToString(this);
        }
    }
}
