package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.SegmentsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Node1Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Node1Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new Node1BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Node1Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Node1Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Node1Builder implements Builder<Node1> {

    private Map<SegmentsKey, Segments> _segments;



    public Node1Builder() {
    }
    
    
    public Node1Builder(SrNodeAttributes arg) {
        this._segments = arg.getSegments();
    }

    public Node1Builder(Node1 base) {
        this._segments = base.getSegments();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SrNodeAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrNodeAttributes) {
            this._segments = ((SrNodeAttributes)arg).getSegments();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SrNodeAttributes]");
    }

    public Map<SegmentsKey, Segments> getSegments() {
        return _segments;
    }

    public Node1Builder setSegments(final Map<SegmentsKey, Segments> values) {
        this._segments = values;
        return this;
    }
    

    @Override
    public Node1 build() {
        return new Node1Impl(this);
    }

    private static final class Node1Impl
        implements Node1 {
    
        private final Map<SegmentsKey, Segments> _segments;
    
        Node1Impl(Node1Builder base) {
            this._segments = CodeHelpers.emptyToNull(base.getSegments());
        }
    
        @Override
        public Map<SegmentsKey, Segments> getSegments() {
            return _segments;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Node1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Node1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Node1.bindingToString(this);
        }
    }
}
