package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link PrefixBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PrefixBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PrefixBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PrefixBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PrefixBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PrefixBuilder implements Builder<Prefix> {

    private Boolean _nodeSid;
    private IpPrefix _prefix;


    Map<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> augmentation = Collections.emptyMap();

    public PrefixBuilder() {
    }
    
    

    public PrefixBuilder(Prefix base) {
        Map<Class<? extends Augmentation<Prefix>>, Augmentation<Prefix>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nodeSid = base.getNodeSid();
        this._prefix = base.getPrefix();
    }


    public Boolean getNodeSid() {
        return _nodeSid;
    }
    
    public IpPrefix getPrefix() {
        return _prefix;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Prefix>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PrefixBuilder setNodeSid(final Boolean value) {
        this._nodeSid = value;
        return this;
    }
    
    public PrefixBuilder setPrefix(final IpPrefix value) {
        this._prefix = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PrefixBuilder addAugmentation(Augmentation<Prefix> augmentation) {
        Class<? extends Augmentation<Prefix>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PrefixBuilder removeAugmentation(Class<? extends Augmentation<Prefix>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Prefix build() {
        return new PrefixImpl(this);
    }

    private static final class PrefixImpl
        extends AbstractAugmentable<Prefix>
        implements Prefix {
    
        private final Boolean _nodeSid;
        private final IpPrefix _prefix;
    
        PrefixImpl(PrefixBuilder base) {
            super(base.augmentation);
            this._nodeSid = base.getNodeSid();
            this._prefix = base.getPrefix();
        }
    
        @Override
        public Boolean getNodeSid() {
            return _nodeSid;
        }
        
        @Override
        public IpPrefix getPrefix() {
            return _prefix;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Prefix.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Prefix.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Prefix.bindingToString(this);
        }
    }
}
