package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the Segment Routing extensions to the base network 
 * model. Copyright (c)2013 Cisco Systems, Inc. All rights reserved. This program 
 * and the accompanying materials are made available under the terms of the 
 * Public License v1.0 which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-sr</b>
 * <pre>
 * module network-topology-sr {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:topology:sr;
 *   prefix sr;
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import network-topology {
 *     prefix nt;
 *     revision-date 2013-10-21;
 *   }
 *   revision 2013-08-19 {
 *   }
 *   typedef segment-id {
 *     type uint32;
 *   }
 *   typedef segment-ref {
 *     type leafref {
 *       path /nt:network-topology/nt:topology/nt:node/segments/segment-id;
 *     }
 *   }
 *   grouping sr-link-attributes {
 *     leaf segment {
 *       type segment-ref;
 *     }
 *   }
 *   grouping sr-node-attributes {
 *     list segments {
 *       leaf segment-id {
 *         type segment-id;
 *       }
 *       key segment-id;
 *       choice segment-specification {
 *         case adjacency-case {
 *           container adjacency {
 *             leaf adjacency {
 *               type nt:link-ref;
 *             }
 *           }
 *         }
 *         case prefix-case {
 *           container prefix {
 *             leaf prefix {
 *               type inet:ip-prefix;
 *             }
 *             leaf node-sid {
 *               type boolean;
 *               default false;
 *             }
 *           }
 *         }
 *       }
 *     }
 *   }
 *   grouping topology-sr-type {
 *     container topology-sr {
 *       presence "indicates a Segment Routing-aware topology";
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:topology-types {
 *     uses topology-sr-type;
 *   }
 *   augment /nt:network-topology/nt:topology/nt:link {
 *     when ../../nt:topology-types/topology-sr;
 *     uses sr-link-attributes;
 *   }
 *   augment /nt:network-topology/nt:topology/nt:node {
 *     when ../../nt:topology-types/topology-sr;
 *     uses sr-node-attributes;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface NetworkTopologySrData
    extends
    DataRoot
{





}

