package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.topology.sr.type.TopologySr;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TopologyTypes1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TopologyTypes1 createTopologyTypes1(int fooXyzzy, int barBaz) {
 *         return new TopologyTypes1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TopologyTypes1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TopologyTypes1
 *
 */
@Generated("mdsal-binding-generator")
public class TopologyTypes1Builder {

    private TopologySr _topologySr;



    /**
     * Construct an empty builder.
     */
    public TopologyTypes1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link TopologySrType}.
     *
     * @param arg TopologySrType from which the builder should be initialized
     */
    public TopologyTypes1Builder(TopologySrType arg) {
        this._topologySr = arg.getTopologySr();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link TopologyTypes1}.
     *
     * @param base TopologyTypes1 from which the builder should be initialized
     */
    public TopologyTypes1Builder(TopologyTypes1 base) {
        this._topologySr = base.getTopologySr();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link TopologySrType}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TopologySrType castArg) {
            this._topologySr = castArg.getTopologySr();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[TopologySrType]");
    }

    /**
     * Return current value associated with the property corresponding to {@link TopologyTypes1#getTopologySr()}.
     *
     * @return current value
     */
    public TopologySr getTopologySr() {
        return _topologySr;
    }

    
    /**
     * Set the property corresponding to {@link TopologyTypes1#getTopologySr()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TopologyTypes1Builder setTopologySr(final TopologySr value) {
        this._topologySr = value;
        return this;
    }
    

    /**
     * A new {@link TopologyTypes1} instance.
     *
     * @return A new {@link TopologyTypes1} instance.
     */
    public @NonNull TopologyTypes1 build() {
        return new TopologyTypes1Impl(this);
    }

    private static final class TopologyTypes1Impl
        implements TopologyTypes1 {
    
        private final TopologySr _topologySr;
    
        TopologyTypes1Impl(TopologyTypes1Builder base) {
            this._topologySr = base.getTopologySr();
        }
    
        @Override
        public TopologySr getTopologySr() {
            return _topologySr;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TopologyTypes1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TopologyTypes1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TopologyTypes1.bindingToString(this);
        }
    }
}
