package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SegmentId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SrNodeAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.SegmentSpecification;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-sr</b>
 * <pre>
 * list segments {
 *   leaf segment-id {
 *     type segment-id;
 *   }
 *   key segment-id;
 *   choice segment-specification {
 *     case adjacency-case {
 *       container adjacency {
 *         leaf adjacency {
 *           type nt:link-ref;
 *         }
 *       }
 *     }
 *     case prefix-case {
 *       container prefix {
 *         leaf prefix {
 *           type inet:ip-prefix;
 *         }
 *         leaf node-sid {
 *           type boolean;
 *           default false;
 *         }
 *       }
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link SegmentsBuilder}.
 * @see SegmentsBuilder
 * @see SegmentsKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Segments
    extends
    ChildOf<SrNodeAttributes>,
    Augmentable<Segments>,
    Identifiable<SegmentsKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("segments");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.@NonNull Segments obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getSegmentId());
        result = prime * result + Objects.hashCode(obj.getSegmentSpecification());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.@NonNull Segments thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getSegmentId(), other.getSegmentId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSegmentSpecification(), other.getSegmentSpecification())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.@NonNull Segments obj) {
        final var helper = MoreObjects.toStringHelper("Segments");
        CodeHelpers.appendValue(helper, "segmentId", obj.getSegmentId());
        CodeHelpers.appendValue(helper, "segmentSpecification", obj.getSegmentSpecification());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    SegmentsKey key();
    
    /**
     * Return segmentId, or {@code null} if it is not present.
     *
     * @return {@code SegmentId} segmentId, or {@code null} if it is not present.
     *
     */
    SegmentId getSegmentId();
    
    /**
     * Return segmentId, guaranteed to be non-null.
     *
     * @return {@code SegmentId} segmentId, guaranteed to be non-null.
     * @throws NoSuchElementException if segmentId is not present
     *
     */
    default @NonNull SegmentId requireSegmentId() {
        return CodeHelpers.require(getSegmentId(), "segmentid");
    }
    
    /**
     * Return segmentSpecification, or {@code null} if it is not present.
     *
     * @return {@code SegmentSpecification} segmentSpecification, or {@code null} if it is not present.
     *
     */
    SegmentSpecification getSegmentSpecification();

}

