package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes;
import com.google.common.base.MoreObjects;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SegmentId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Segments} class.
 *
 * @see Segments
 *
 */
@Generated("mdsal-binding-generator")
public class SegmentsKey
 implements Identifier<Segments> {
    private static final long serialVersionUID = 5753413386143707199L;
    private final SegmentId _segmentId;


    /**
     * Constructs an instance.
     *
     * @param _segmentId the entity segmentId
     * @throws NullPointerException if any of the arguments are null
     */
    public SegmentsKey(@NonNull SegmentId _segmentId) {
        this._segmentId = CodeHelpers.requireKeyProp(_segmentId, "segmentId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public SegmentsKey(SegmentsKey source) {
        this._segmentId = source._segmentId;
    }


    /**
     * Return segmentId, guaranteed to be non-null.
     *
     * @return {@code SegmentId} segmentId, guaranteed to be non-null.
     */
    public @NonNull SegmentId getSegmentId() {
        return _segmentId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_segmentId);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SegmentsKey)) {
            return false;
        }
        final SegmentsKey other = (SegmentsKey) obj;
        if (!Objects.equals(_segmentId, other._segmentId)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(SegmentsKey.class);
        CodeHelpers.appendValue(helper, "segmentId", _segmentId);
        return helper.toString();
    }
}

