package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.sr.rev130819.tunnel.sr.type.SrTunnel;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PathTypes1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PathTypes1 createPathTypes1(int fooXyzzy, int barBaz) {
 *         return new PathTypes1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PathTypes1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PathTypes1
 *
 */
@Generated("mdsal-binding-generator")
public class PathTypes1Builder {

    private SrTunnel _srTunnel;



    /**
     * Construct an empty builder.
     */
    public PathTypes1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link TunnelSrType}.
     *
     * @param arg TunnelSrType from which the builder should be initialized
     */
    public PathTypes1Builder(TunnelSrType arg) {
        this._srTunnel = arg.getSrTunnel();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link PathTypes1}.
     *
     * @param base PathTypes1 from which the builder should be initialized
     */
    public PathTypes1Builder(PathTypes1 base) {
        this._srTunnel = base.getSrTunnel();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link TunnelSrType}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TunnelSrType castArg) {
            this._srTunnel = castArg.getSrTunnel();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[TunnelSrType]");
    }

    /**
     * Return current value associated with the property corresponding to {@link PathTypes1#getSrTunnel()}.
     *
     * @return current value
     */
    public SrTunnel getSrTunnel() {
        return _srTunnel;
    }

    
    /**
     * Set the property corresponding to {@link PathTypes1#getSrTunnel()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathTypes1Builder setSrTunnel(final SrTunnel value) {
        this._srTunnel = value;
        return this;
    }
    

    /**
     * A new {@link PathTypes1} instance.
     *
     * @return A new {@link PathTypes1} instance.
     */
    public @NonNull PathTypes1 build() {
        return new PathTypes1Impl(this);
    }

    private static final class PathTypes1Impl
        implements PathTypes1 {
    
        private final SrTunnel _srTunnel;
    
        PathTypes1Impl(PathTypes1Builder base) {
            this._srTunnel = base.getSrTunnel();
        }
    
        @Override
        public SrTunnel getSrTunnel() {
            return _srTunnel;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PathTypes1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PathTypes1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PathTypes1.bindingToString(this);
        }
    }
}
