package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-sr</b>
 * <pre>
 * grouping sr-link-attributes {
 *   leaf segment {
 *     type segment-ref;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SrLinkAttributes
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("sr-link-attributes");

    @Override
    Class<? extends SrLinkAttributes> implementedInterface();
    
    /**
     * Return segment, or {@code null} if it is not present.
     *
     * @return {@code SegmentId} segment, or {@code null} if it is not present.
     *
     */
    SegmentId getSegment();
    
    /**
     * Return segment, guaranteed to be non-null.
     *
     * @return {@code SegmentId} segment, guaranteed to be non-null.
     * @throws NoSuchElementException if segment is not present
     *
     */
    default @NonNull SegmentId requireSegment() {
        return CodeHelpers.require(getSegment(), "segment");
    }

}

