package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SegmentId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.SegmentSpecification;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Segments} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Segments createSegments(int fooXyzzy, int barBaz) {
 *         return new SegmentsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Segments, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Segments
 *
 */
@Generated("mdsal-binding-generator")
public class SegmentsBuilder {

    private SegmentId _segmentId;
    private SegmentSpecification _segmentSpecification;
    private SegmentsKey key;


    Map<Class<? extends Augmentation<Segments>>, Augmentation<Segments>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SegmentsBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Segments}.
     *
     * @param base Segments from which the builder should be initialized
     */
    public SegmentsBuilder(Segments base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._segmentId = base.getSegmentId();
        this._segmentSpecification = base.getSegmentSpecification();
    }



    /**
     * Return current value associated with the property corresponding to {@link Segments#key()}.
     *
     * @return current value
     */
    public SegmentsKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Segments#getSegmentId()}.
     *
     * @return current value
     */
    public SegmentId getSegmentId() {
        return _segmentId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Segments#getSegmentSpecification()}.
     *
     * @return current value
     */
    public SegmentSpecification getSegmentSpecification() {
        return _segmentSpecification;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Segments>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Segments#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public SegmentsBuilder withKey(final SegmentsKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Segments#getSegmentId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SegmentsBuilder setSegmentId(final SegmentId value) {
        this._segmentId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Segments#getSegmentSpecification()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SegmentsBuilder setSegmentSpecification(final SegmentSpecification value) {
        this._segmentSpecification = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SegmentsBuilder addAugmentation(Augmentation<Segments> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SegmentsBuilder removeAugmentation(Class<? extends Augmentation<Segments>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Segments} instance.
     *
     * @return A new {@link Segments} instance.
     */
    public @NonNull Segments build() {
        return new SegmentsImpl(this);
    }

    private static final class SegmentsImpl
        extends AbstractAugmentable<Segments>
        implements Segments {
    
        private final SegmentId _segmentId;
        private final SegmentSpecification _segmentSpecification;
        private final SegmentsKey key;
    
        SegmentsImpl(SegmentsBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new SegmentsKey(base.getSegmentId());
            }
            this._segmentId = key.getSegmentId();
            this._segmentSpecification = base.getSegmentSpecification();
        }
    
        @Override
        public SegmentsKey key() {
            return key;
        }
        
        @Override
        public SegmentId getSegmentId() {
            return _segmentId;
        }
        
        @Override
        public SegmentSpecification getSegmentSpecification() {
            return _segmentSpecification;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Segments.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Segments.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Segments.bindingToString(this);
        }
    }
}
