package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-sr</b>
 * <pre>
 * container prefix {
 *   leaf prefix {
 *     type inet:ip-prefix;
 *   }
 *   leaf node-sid {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link PrefixBuilder}.
 * @see PrefixBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Prefix
    extends
    ChildOf<Segments>,
    Augmentable<Prefix>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("prefix");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case.Prefix> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case.Prefix.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case.@NonNull Prefix obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getNodeSid());
        result = prime * result + Objects.hashCode(obj.getPrefix());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case.@NonNull Prefix thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case.Prefix.class, obj);
        return other != null
            && Objects.equals(thisObj.getNodeSid(), other.getNodeSid())
            && Objects.equals(thisObj.getPrefix(), other.getPrefix())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.prefix._case.@NonNull Prefix obj) {
        final var helper = MoreObjects.toStringHelper("Prefix");
        CodeHelpers.appendValue(helper, "nodeSid", obj.getNodeSid());
        CodeHelpers.appendValue(helper, "prefix", obj.getPrefix());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return prefix, or {@code null} if it is not present.
     *
     * @return {@code IpPrefix} prefix, or {@code null} if it is not present.
     *
     */
    IpPrefix getPrefix();
    
    /**
     * Return prefix, guaranteed to be non-null.
     *
     * @return {@code IpPrefix} prefix, guaranteed to be non-null.
     * @throws NoSuchElementException if prefix is not present
     *
     */
    default @NonNull IpPrefix requirePrefix() {
        return CodeHelpers.require(getPrefix(), "prefix");
    }
    
    /**
     * Return nodeSid, or {@code null} if it is not present.
     *
     * @return {@code Boolean} nodeSid, or {@code null} if it is not present.
     *
     */
    Boolean getNodeSid();
    
    /**
     * Return nodeSid, guaranteed to be non-null.
     *
     * @return {@code Boolean} nodeSid, guaranteed to be non-null.
     * @throws NoSuchElementException if nodeSid is not present
     *
     */
    default @NonNull Boolean requireNodeSid() {
        return CodeHelpers.require(getNodeSid(), "nodesid");
    }

}

