/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.SegmentId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.SegmentsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.SegmentSpecification;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SegmentsBuilder {
    private SegmentsKey _key;
    private SegmentId _segmentId;
    private static List<Range<BigInteger>> _segmentId_range;
    private SegmentSpecification _segmentSpecification;
    Map<Class<? extends Augmentation<Segments>>, Augmentation<Segments>> augmentation = new HashMap<Class<? extends Augmentation<Segments>>, Augmentation<Segments>>();

    public SegmentsBuilder() {
    }

    public SegmentsBuilder(Segments base) {
        if (base.getKey() == null) {
            this._key = new SegmentsKey(base.getSegmentId());
            this._segmentId = base.getSegmentId();
        } else {
            this._key = base.getKey();
            this._segmentId = this._key.getSegmentId();
        }
        this._segmentSpecification = base.getSegmentSpecification();
        if (base instanceof SegmentsImpl) {
            SegmentsImpl _impl = (SegmentsImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Segments>>, Augmentation<Segments>>(_impl.augmentation);
        }
    }

    public SegmentsKey getKey() {
        return this._key;
    }

    public SegmentId getSegmentId() {
        return this._segmentId;
    }

    public SegmentSpecification getSegmentSpecification() {
        return this._segmentSpecification;
    }

    public <E extends Augmentation<Segments>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SegmentsBuilder setKey(SegmentsKey value) {
        this._key = value;
        return this;
    }

    public SegmentsBuilder setSegmentId(SegmentId value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : SegmentsBuilder._segmentId_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _segmentId_range));
            }
        }
        this._segmentId = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _segmentId_range() {
        if (_segmentId_range != null) return _segmentId_range;
        Class<SegmentsBuilder> clazz = SegmentsBuilder.class;
        synchronized (SegmentsBuilder.class) {
            if (_segmentId_range != null) return _segmentId_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _segmentId_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _segmentId_range;
        }
    }

    public SegmentsBuilder setSegmentSpecification(SegmentSpecification value) {
        this._segmentSpecification = value;
        return this;
    }

    public SegmentsBuilder addAugmentation(Class<? extends Augmentation<Segments>> augmentationType, Augmentation<Segments> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Segments build() {
        return new SegmentsImpl(this);
    }

    private static final class SegmentsImpl
    implements Segments {
        private final SegmentsKey _key;
        private final SegmentId _segmentId;
        private final SegmentSpecification _segmentSpecification;
        private Map<Class<? extends Augmentation<Segments>>, Augmentation<Segments>> augmentation = new HashMap<Class<? extends Augmentation<Segments>>, Augmentation<Segments>>();

        public Class<Segments> getImplementedInterface() {
            return Segments.class;
        }

        private SegmentsImpl(SegmentsBuilder base) {
            if (base.getKey() == null) {
                this._key = new SegmentsKey(base.getSegmentId());
                this._segmentId = base.getSegmentId();
            } else {
                this._key = base.getKey();
                this._segmentId = this._key.getSegmentId();
            }
            this._segmentSpecification = base.getSegmentSpecification();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Segments>>, Augmentation<Segments>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Segments>>, Augmentation<Segments>>(base.augmentation);
                }
            }
        }

        @Override
        public SegmentsKey getKey() {
            return this._key;
        }

        @Override
        public SegmentId getSegmentId() {
            return this._segmentId;
        }

        @Override
        public SegmentSpecification getSegmentSpecification() {
            return this._segmentSpecification;
        }

        public <E extends Augmentation<Segments>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._segmentId == null ? 0 : this._segmentId.hashCode());
            result = 31 * result + (this._segmentSpecification == null ? 0 : this._segmentSpecification.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Segments.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Segments other = (Segments)obj;
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._segmentId == null ? other.getSegmentId() != null : !this._segmentId.equals(other.getSegmentId())) {
                return false;
            }
            if (this._segmentSpecification == null ? other.getSegmentSpecification() != null : !this._segmentSpecification.equals(other.getSegmentSpecification())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SegmentsImpl otherImpl = (SegmentsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Segments>>, Augmentation<Segments>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Segments [");
            boolean first = true;
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._segmentId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_segmentId=");
                builder.append(this._segmentId);
            }
            if (this._segmentSpecification != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_segmentSpecification=");
                builder.append(this._segmentSpecification);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

