/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.NodeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.node._case.Node;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeCaseBuilder {
    private Node _node;
    Map<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>> augmentation = new HashMap<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>>();

    public NodeCaseBuilder() {
    }

    public NodeCaseBuilder(NodeCase base) {
        this._node = base.getNode();
        if (base instanceof NodeCaseImpl) {
            NodeCaseImpl _impl = (NodeCaseImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>>(_impl.augmentation);
        }
    }

    public Node getNode() {
        return this._node;
    }

    public <E extends Augmentation<NodeCase>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeCaseBuilder setNode(Node value) {
        this._node = value;
        return this;
    }

    public NodeCaseBuilder addAugmentation(Class<? extends Augmentation<NodeCase>> augmentationType, Augmentation<NodeCase> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeCase build() {
        return new NodeCaseImpl(this);
    }

    private static final class NodeCaseImpl
    implements NodeCase {
        private final Node _node;
        private Map<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>> augmentation = new HashMap<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>>();

        public Class<NodeCase> getImplementedInterface() {
            return NodeCase.class;
        }

        private NodeCaseImpl(NodeCaseBuilder base) {
            this._node = base.getNode();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>>(base.augmentation);
                }
            }
        }

        @Override
        public Node getNode() {
            return this._node;
        }

        public <E extends Augmentation<NodeCase>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeCase.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NodeCase other = (NodeCase)obj;
            if (this._node == null ? other.getNode() != null : !this._node.equals(other.getNode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeCaseImpl otherImpl = (NodeCaseImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NodeCase>>, Augmentation<NodeCase>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NodeCase [");
            boolean first = true;
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

