/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.node._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.sr.rev130819.sr.node.attributes.segments.segment.specification.node._case.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeBuilder {
    private NodeId _node;
    Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();

    public NodeBuilder() {
    }

    public NodeBuilder(Node base) {
        this._node = base.getNode();
        if (base instanceof NodeImpl) {
            NodeImpl _impl = (NodeImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(_impl.augmentation);
        }
    }

    public NodeId getNode() {
        return this._node;
    }

    public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public NodeBuilder addAugmentation(Class<? extends Augmentation<Node>> augmentationType, Augmentation<Node> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    implements Node {
        private final NodeId _node;
        private Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();

        public Class<Node> getImplementedInterface() {
            return Node.class;
        }

        private NodeImpl(NodeBuilder base) {
            this._node = base.getNode();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Node>>, Augmentation<Node>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(base.augmentation);
                }
            }
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._node == null ? 0 : this._node.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Node.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Node other = (Node)obj;
            if (this._node == null ? other.getNode() != null : !this._node.equals((Object)other.getNode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeImpl otherImpl = (NodeImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Node>>, Augmentation<Node>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Node [");
            boolean first = true;
            if (this._node != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_node=");
                builder.append(this._node);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

