/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class JournalSegmentDescriptor {
    public static final int BYTES = 64;
    @VisibleForTesting
    static final int VERSION = 1;
    private static final int VERSION_LENGTH = 4;
    private static final int ID_LENGTH = 8;
    private static final int INDEX_LENGTH = 8;
    private static final int MAX_SIZE_LENGTH = 4;
    private static final int MAX_ENTRIES_LENGTH = 4;
    private static final int UPDATED_LENGTH = 8;
    private static final int VERSION_POSITION = 0;
    private static final int ID_POSITION = 4;
    private static final int INDEX_POSITION = 12;
    private static final int MAX_SIZE_POSITION = 20;
    private static final int MAX_ENTRIES_POSITION = 24;
    private static final int UPDATED_POSITION = 28;
    private final ByteBuffer buffer;
    private final int version;
    private final long id;
    private final long index;
    private final int maxSegmentSize;
    private final int maxEntries;
    private volatile long updated;
    private volatile boolean locked;

    public static Builder builder() {
        return new Builder(ByteBuffer.allocate(64));
    }

    public static Builder builder(ByteBuffer buffer) {
        return new Builder(buffer);
    }

    public JournalSegmentDescriptor(ByteBuffer buffer) {
        this.buffer = buffer;
        this.version = buffer.getInt();
        this.id = buffer.getLong();
        this.index = buffer.getLong();
        this.maxSegmentSize = buffer.getInt();
        this.maxEntries = buffer.getInt();
        this.updated = buffer.getLong();
        this.locked = buffer.get() == 1;
    }

    public int version() {
        return this.version;
    }

    public long id() {
        return this.id;
    }

    public long index() {
        return this.index;
    }

    public int maxSegmentSize() {
        return this.maxSegmentSize;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long updated() {
        return this.updated;
    }

    public void update(long timestamp) {
        if (!this.locked) {
            this.buffer.putLong(28, timestamp);
            this.updated = timestamp;
        }
    }

    JournalSegmentDescriptor copyTo(ByteBuffer buffer) {
        buffer.putInt(this.version);
        buffer.putLong(this.id);
        buffer.putLong(this.index);
        buffer.putInt(this.maxSegmentSize);
        buffer.putInt(this.maxEntries);
        buffer.putLong(this.updated);
        buffer.put(this.locked ? (byte)1 : 0);
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("id", this.id).add("index", this.index).add("updated", this.updated).toString();
    }

    public static class Builder {
        private final ByteBuffer buffer;

        private Builder(ByteBuffer buffer) {
            this.buffer = Objects.requireNonNull(buffer, "buffer cannot be null");
            buffer.putInt(0, 1);
        }

        public Builder withId(long id) {
            this.buffer.putLong(4, id);
            return this;
        }

        public Builder withIndex(long index) {
            this.buffer.putLong(12, index);
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.buffer.putInt(20, maxSegmentSize);
            return this;
        }

        @Deprecated
        public Builder withMaxEntries(int maxEntries) {
            this.buffer.putInt(24, maxEntries);
            return this;
        }

        public JournalSegmentDescriptor build() {
            this.buffer.rewind();
            return new JournalSegmentDescriptor(this.buffer);
        }
    }
}

