/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import io.atomix.storage.journal.JournalSerdes;
import java.io.IOException;
import java.util.Objects;

final class KryoEntryInput
implements JournalSerdes.EntryInput {
    private final Kryo kryo;
    private final Input input;
    private final JavaSerializer javaSerializer;

    KryoEntryInput(Kryo kryo, Input input, JavaSerializer javaSerializer) {
        this.kryo = Objects.requireNonNull(kryo);
        this.input = Objects.requireNonNull(input);
        this.javaSerializer = Objects.requireNonNull(javaSerializer);
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        try {
            return this.input.readBytes(length);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.input.readLong(false);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object readObject() throws IOException {
        try {
            return this.javaSerializer.read(this.kryo, this.input, (Class)null);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String readString() throws IOException {
        try {
            return this.input.readString();
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int readVarInt() throws IOException {
        try {
            return this.input.readVarInt(true);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }
}

