/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.google.common.base.MoreObjects;
import io.atomix.storage.journal.JournalSerdes;
import io.atomix.utils.serializer.KryoInputPool;
import io.atomix.utils.serializer.KryoOutputPool;
import io.atomix.utils.serializer.RegisteredType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KryoJournalSerdes
implements JournalSerdes,
KryoFactory,
KryoPool {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int INITIAL_ID = 16;
    static final String NO_NAME = "(no name)";
    private static final Logger LOGGER = LoggerFactory.getLogger(KryoJournalSerdes.class);
    private final KryoPool kryoPool = new KryoPool.Builder(this).softReferences().build();
    private final KryoOutputPool kryoOutputPool = new KryoOutputPool();
    private final KryoInputPool kryoInputPool = new KryoInputPool();
    private final List<RegisteredType> registeredTypes;
    private final ClassLoader classLoader;
    private final String friendlyName;

    KryoJournalSerdes(List<RegisteredType> registeredTypes, ClassLoader classLoader, String friendlyName) {
        this.registeredTypes = List.copyOf(registeredTypes);
        this.classLoader = Objects.requireNonNull(classLoader);
        this.friendlyName = Objects.requireNonNull(friendlyName);
        this.release(this.create());
    }

    @Override
    public byte[] serialize(Object obj) {
        return this.serialize(obj, 4096);
    }

    @Override
    public byte[] serialize(Object obj, int bufferSize) {
        return this.kryoOutputPool.run(output -> this.kryoPool.run(kryo -> {
            kryo.writeClassAndObject((Output)output, obj);
            output.flush();
            return output.getByteArrayOutputStream().toByteArray();
        }), bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Object obj, ByteBuffer buffer) {
        ByteBufferOutput out = new ByteBufferOutput(buffer);
        Kryo kryo = this.borrow();
        try {
            kryo.writeClassAndObject(out, obj);
            out.flush();
        }
        finally {
            this.release(kryo);
        }
    }

    @Override
    public void serialize(Object obj, OutputStream stream) {
        this.serialize(obj, stream, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Object obj, OutputStream stream, int bufferSize) {
        ByteBufferOutput out = new ByteBufferOutput(stream, bufferSize);
        Kryo kryo = this.borrow();
        try {
            kryo.writeClassAndObject(out, obj);
            out.flush();
        }
        finally {
            this.release(kryo);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        return (T)this.kryoInputPool.run(input -> {
            input.setInputStream(new ByteArrayInputStream(bytes));
            return this.kryoPool.run(kryo -> {
                Object obj = kryo.readClassAndObject((Input)input);
                return obj;
            });
        }, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(ByteBuffer buffer) {
        ByteBufferInput in = new ByteBufferInput(buffer);
        Kryo kryo = this.borrow();
        try {
            Object obj;
            Object object = obj = kryo.readClassAndObject(in);
            return (T)object;
        }
        finally {
            this.release(kryo);
        }
    }

    @Override
    public <T> T deserialize(InputStream stream) {
        return this.deserialize(stream, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(InputStream stream, int bufferSize) {
        ByteBufferInput in = new ByteBufferInput(stream, bufferSize);
        Kryo kryo = this.borrow();
        try {
            Object obj;
            Object object = obj = kryo.readClassAndObject(in);
            return (T)object;
        }
        finally {
            this.release(kryo);
        }
    }

    @Override
    public Kryo create() {
        LOGGER.trace("Creating Kryo instance for {}", (Object)this);
        Kryo kryo = new Kryo();
        kryo.setClassLoader(this.classLoader);
        kryo.setRegistrationRequired(true);
        kryo.setInstantiatorStrategy(new Kryo.DefaultInstantiatorStrategy(new StdInstantiatorStrategy()));
        int id = 16;
        for (RegisteredType registeredType : this.registeredTypes) {
            this.register(kryo, registeredType.types(), registeredType.serializer(), id++);
        }
        return kryo;
    }

    private void register(Kryo kryo, Class<?>[] types, Serializer<?> serializer, int id) {
        Registration existing = kryo.getRegistration(id);
        if (existing != null) {
            boolean matches = false;
            Class<?>[] classArray = types;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> type = classArray[i];
                if (existing.getType() != type) continue;
                matches = true;
                break;
            }
            if (!matches) {
                LOGGER.error("{}: Failed to register {} as {}, {} was already registered.", new Object[]{this.friendlyName, types, id, existing.getType()});
                throw new IllegalStateException(String.format("Failed to register %s as %s, %s was already registered.", Arrays.toString(types), id, existing.getType()));
            }
        }
        for (Class<?> type : types) {
            Registration r = null;
            if (serializer == null) {
                r = kryo.register(type, id);
            } else if (type.isInterface()) {
                kryo.addDefaultSerializer(type, serializer);
            } else {
                r = kryo.register(type, serializer, id);
            }
            if (r == null) continue;
            if (r.getId() != id) {
                LOGGER.debug("{}: {} already registered as {}. Skipping {}.", new Object[]{this.friendlyName, r.getType(), r.getId(), id});
            }
            LOGGER.trace("{} registered as {}", (Object)r.getType(), (Object)r.getId());
        }
    }

    @Override
    public Kryo borrow() {
        return this.kryoPool.borrow();
    }

    @Override
    public void release(Kryo kryo) {
        this.kryoPool.release(kryo);
    }

    @Override
    public <T> T run(KryoCallback<T> callback) {
        return this.kryoPool.run(callback);
    }

    public String toString() {
        if (!NO_NAME.equals(this.friendlyName)) {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("friendlyName", (Object)this.friendlyName).toString();
        }
        return MoreObjects.toStringHelper(this.getClass()).add("registeredTypes", this.registeredTypes).toString();
    }
}

