/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import io.atomix.storage.journal.JournalSerdes;
import java.io.IOException;
import java.util.Objects;

final class KryoEntryOutput
implements JournalSerdes.EntryOutput {
    private final Kryo kryo;
    private final Output output;
    private final JavaSerializer javaSerializer;

    KryoEntryOutput(Kryo kryo, Output output, JavaSerializer javaSerializer) {
        this.kryo = Objects.requireNonNull(kryo);
        this.output = Objects.requireNonNull(output);
        this.javaSerializer = Objects.requireNonNull(javaSerializer);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        try {
            this.output.writeBytes(bytes);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeLong(long value) throws IOException {
        try {
            this.output.writeLong(value, false);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeObject(Object value) throws IOException {
        try {
            this.javaSerializer.write(this.kryo, this.output, value);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeString(String value) throws IOException {
        try {
            this.output.writeString(value);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeVarInt(int value) throws IOException {
        try {
            this.output.writeVarInt(value, true);
        }
        catch (KryoException e) {
            throw new IOException(e);
        }
    }
}

