/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.google.common.base.Preconditions;
import io.atomix.storage.journal.JournalSerdes;
import io.atomix.utils.serializer.EntrySerializer;
import io.atomix.utils.serializer.KryoJournalSerdes;
import io.atomix.utils.serializer.RegisteredType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class KryoJournalSerdesBuilder
implements JournalSerdes.Builder {
    private final List<RegisteredType> types = new ArrayList<RegisteredType>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    @Override
    public KryoJournalSerdesBuilder register(JournalSerdes.EntrySerdes<?> serdes, Class<?> ... classes) {
        this.types.add(new RegisteredType(new EntrySerializer(serdes), classes));
        return this;
    }

    @Override
    public KryoJournalSerdesBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader);
        return this;
    }

    @Override
    public JournalSerdes build() {
        return this.build("(no name)");
    }

    @Override
    public JournalSerdes build(String friendlyName) {
        Preconditions.checkState((!this.types.isEmpty() ? 1 : 0) != 0, (Object)"No serializers registered");
        return new KryoJournalSerdes(this.types, this.classLoader, friendlyName);
    }
}

