package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * grouping payload {
 *     list payload {
 *         key "id"
 *         leaf id {
 *             type int32;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbench-payload/payload</i>
 *
 */
public interface Payload
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("rpcbench-payload",
        "2015-07-02", "payload").intern();

    /**
     * The input and output payload for the RPC Benchmark's Global RPC Server (a list 
     * of integers)
     *
     *
     *
     * @return <code>java.util.List</code> <code>payload</code>, or <code>null</code> if not present
     */
    List<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload> getPayload();

}

