package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import java.util.List;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.Payload;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput
 *
 */
public class RoutedRpcBenchInputBuilder implements Builder <org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput> {

    private InstanceIdentifier<?> _node;
    private List<Payload> _payload;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> augmentation = Collections.emptyMap();

    public RoutedRpcBenchInputBuilder() {
    }
    public RoutedRpcBenchInputBuilder(org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload arg) {
        this._payload = arg.getPayload();
    }

    public RoutedRpcBenchInputBuilder(RoutedRpcBenchInput base) {
        this._node = base.getNode();
        this._payload = base.getPayload();
        if (base instanceof RoutedRpcBenchInputImpl) {
            RoutedRpcBenchInputImpl impl = (RoutedRpcBenchInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload) {
            this._payload = ((org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload)arg).getPayload();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.Payload] \n" +
              "but was: " + arg
            );
        }
    }

    public InstanceIdentifier<?> getNode() {
        return _node;
    }
    
    public List<Payload> getPayload() {
        return _payload;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public RoutedRpcBenchInputBuilder setNode(final InstanceIdentifier<?> value) {
        this._node = value;
        return this;
    }
    
     
    public RoutedRpcBenchInputBuilder setPayload(final List<Payload> value) {
        this._payload = value;
        return this;
    }
    
    public RoutedRpcBenchInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public RoutedRpcBenchInputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RoutedRpcBenchInput build() {
        return new RoutedRpcBenchInputImpl(this);
    }

    private static final class RoutedRpcBenchInputImpl implements RoutedRpcBenchInput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput.class;
        }

        private final InstanceIdentifier<?> _node;
        private final List<Payload> _payload;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> augmentation = Collections.emptyMap();

        private RoutedRpcBenchInputImpl(RoutedRpcBenchInputBuilder base) {
            this._node = base.getNode();
            this._payload = base.getPayload();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public InstanceIdentifier<?> getNode() {
            return _node;
        }
        
        @Override
        public List<Payload> getPayload() {
            return _payload;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_node);
            result = prime * result + Objects.hashCode(_payload);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput other = (org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput)obj;
            if (!Objects.equals(_node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(_payload, other.getPayload())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RoutedRpcBenchInputImpl otherImpl = (RoutedRpcBenchInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RoutedRpcBenchInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "RoutedRpcBenchInput [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_node != null) {
                builder.append("_node=");
                builder.append(_node);
                builder.append(", ");
            }
            if (_payload != null) {
                builder.append("_payload=");
                builder.append(_payload);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
