package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * module rpcbench-payload {
 *     yang-version 1;
 *     namespace "rpcbench-payload";
 *     prefix "rpcb";
 *
 *     import yang-ext { prefix "ext"; }
 *     revision 2015-07-02 {
 *         description "";
 *     }
 *
 *     container rpcbench-rpc-routes {
 *         list rpc-route {
 *             key "id"
 *             leaf id {
 *                 type string;
 *             }
 *         }
 *     }
 *
 *     grouping payload {
 *         list payload {
 *             key "id"
 *             leaf id {
 *                 type int32;
 *             }
 *         }
 *     }
 *
 *     identity node-context {
 *         description
 *             "Identity used to mark node context for Routed RPCs (determines the type of routing)";
 *         status CURRENT;
 *     }
 *
 *     rpc global-rpc-bench {
 *         "Interface to the RPC Benchmark's Global RPC Server. In each RPC call, the input is copied on the output";
 *         input {
 *             list payload {
 *                 key "id"
 *                 leaf id {
 *                     type int32;
 *                 }
 *             }
 *         }
 *         
 *         output {
 *             list payload {
 *                 key "id"
 *                 leaf id {
 *                     type int32;
 *                 }
 *             }
 *         }
 *     }
 *     rpc routed-rpc-bench {
 *         "Interface to RPC Benchmark's Routed RPC Servers. In each RPC call, the input is copied on the output";
 *         input {
 *             leaf node {
 *                 type instance-identifier;
 *             }
 *             list payload {
 *                 key "id"
 *                 leaf id {
 *                     type int32;
 *                 }
 *             }
 *         }
 *         
 *         output {
 *             list payload {
 *                 key "id"
 *                 leaf id {
 *                     type int32;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface RpcbenchPayloadData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes</code> <code>rpcbenchRpcRoutes</code>, or <code>null</code> if not present
     */
    RpcbenchRpcRoutes getRpcbenchRpcRoutes();

}

