package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>rpcbench-payload</b>
 * <pre>
 * rpc global-rpc-bench {
 *     "Interface to the RPC Benchmark's Global RPC Server. In each RPC call, the input is copied on the output";
 *     input {
 *         list payload {
 *             key "id"
 *             leaf id {
 *                 type int32;
 *             }
 *         }
 *     }
 *     
 *     output {
 *         list payload {
 *             key "id"
 *             leaf id {
 *                 type int32;
 *             }
 *         }
 *     }
 * }
 * rpc routed-rpc-bench {
 *     "Interface to RPC Benchmark's Routed RPC Servers. In each RPC call, the input is copied on the output";
 *     input {
 *         leaf node {
 *             type instance-identifier;
 *         }
 *         list payload {
 *             key "id"
 *             leaf id {
 *                 type int32;
 *             }
 *         }
 *     }
 *     
 *     output {
 *         list payload {
 *             key "id"
 *             leaf id {
 *                 type int32;
 *             }
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface RpcbenchPayloadService
    extends
    RpcService
{




    /**
     * Interface to the RPC Benchmark's Global RPC Server. In each RPC call, the input 
     * is copied on the output
     *
     */
    Future<RpcResult<GlobalRpcBenchOutput>> globalRpcBench(GlobalRpcBenchInput input);
    
    /**
     * Interface to RPC Benchmark's Routed RPC Servers. In each RPC call, the input is 
     * copied on the output
     *
     */
    Future<RpcResult<RoutedRpcBenchOutput>> routedRpcBench(RoutedRpcBenchInput input);

}

