package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>rpcbench-payload</b>
 * <pre>
 * container rpcbench-rpc-routes {
 *     list rpc-route {
 *         key "id"
 *         leaf id {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>rpcbench-payload/rpcbench-rpc-routes</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutesBuilder}.
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutesBuilder
 *
 */
public interface RpcbenchRpcRoutes
    extends
    ChildOf<RpcbenchPayloadData>,
    Augmentable<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("rpcbench-payload",
        "2015-07-02", "rpcbench-rpc-routes").intern();

    /**
     * Routed RPC server context instances (i.e. instances to which RPC calls are 
     * routed)
     *
     *
     *
     * @return <code>java.util.List</code> <code>rpcRoute</code>, or <code>null</code> if not present
     */
    List<RpcRoute> getRpcRoute();

}

