package org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.List;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes} instances.
 *
 * @see org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes
 *
 */
public class RpcbenchRpcRoutesBuilder implements Builder <org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes> {

    private List<RpcRoute> _rpcRoute;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> augmentation = Collections.emptyMap();

    public RpcbenchRpcRoutesBuilder() {
    }

    public RpcbenchRpcRoutesBuilder(RpcbenchRpcRoutes base) {
        this._rpcRoute = base.getRpcRoute();
        if (base instanceof RpcbenchRpcRoutesImpl) {
            RpcbenchRpcRoutesImpl impl = (RpcbenchRpcRoutesImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public List<RpcRoute> getRpcRoute() {
        return _rpcRoute;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public RpcbenchRpcRoutesBuilder setRpcRoute(final List<RpcRoute> value) {
        this._rpcRoute = value;
        return this;
    }
    
    public RpcbenchRpcRoutesBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public RpcbenchRpcRoutesBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RpcbenchRpcRoutes build() {
        return new RpcbenchRpcRoutesImpl(this);
    }

    private static final class RpcbenchRpcRoutesImpl implements RpcbenchRpcRoutes {

        public java.lang.Class<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes.class;
        }

        private final List<RpcRoute> _rpcRoute;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> augmentation = Collections.emptyMap();

        private RpcbenchRpcRoutesImpl(RpcbenchRpcRoutesBuilder base) {
            this._rpcRoute = base.getRpcRoute();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public List<RpcRoute> getRpcRoute() {
            return _rpcRoute;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_rpcRoute);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes other = (org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes)obj;
            if (!Objects.equals(_rpcRoute, other.getRpcRoute())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RpcbenchRpcRoutesImpl otherImpl = (RpcbenchRpcRoutesImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>>, Augmentation<org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "RpcbenchRpcRoutes [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_rpcRoute != null) {
                builder.append("_rpcRoute=");
                builder.append(_rpcRoute);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
